/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.profiles;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.thing.profiles.ProfileCallback;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeUID;
import org.eclipse.smarthome.core.thing.profiles.StateProfile;
import org.eclipse.smarthome.core.thing.profiles.SystemProfiles;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class SystemFollowProfile
implements StateProfile {
    private final Logger logger = LoggerFactory.getLogger(SystemFollowProfile.class);
    private final ProfileCallback callback;

    public SystemFollowProfile(ProfileCallback callback) {
        this.callback = callback;
    }

    @Override
    public ProfileTypeUID getProfileTypeUID() {
        return SystemProfiles.FOLLOW;
    }

    @Override
    public void onStateUpdateFromItem(State state) {
        if (!(state instanceof Command)) {
            this.logger.debug("The given state {} could not be transformed to a command", (Object)state);
            return;
        }
        Command command = (Command)state;
        this.callback.handleCommand(command);
    }

    @Override
    public void onCommandFromHandler(Command command) {
        this.callback.sendCommand(command);
    }

    @Override
    public void onCommandFromItem(Command command) {
    }

    @Override
    public void onStateUpdateFromHandler(State state) {
    }
}

