/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.profiles;

import java.math.BigDecimal;
import javax.measure.UnconvertibleException;
import javax.measure.quantity.Temperature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.unit.ImperialUnits;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.thing.profiles.ProfileCallback;
import org.eclipse.smarthome.core.thing.profiles.ProfileContext;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeUID;
import org.eclipse.smarthome.core.thing.profiles.StateProfile;
import org.eclipse.smarthome.core.thing.profiles.SystemProfiles;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class SystemOffsetProfile
implements StateProfile {
    private static final @Nullable QuantityType<Temperature> ZERO_CELSIUS_IN_KELVIN = new QuantityType((Number)0, SIUnits.CELSIUS).toUnit(SmartHomeUnits.KELVIN);
    private static final @Nullable QuantityType<Temperature> ZERO_FAHRENHEIT_IN_KELVIN = new QuantityType((Number)0, ImperialUnits.FAHRENHEIT).toUnit(SmartHomeUnits.KELVIN);
    private final Logger logger = LoggerFactory.getLogger(SystemOffsetProfile.class);
    private static final String OFFSET_PARAM = "offset";
    private final ProfileCallback callback;
    private final ProfileContext context;
    private @Nullable QuantityType<?> offset;

    public SystemOffsetProfile(ProfileCallback callback, ProfileContext context) {
        this.callback = callback;
        this.context = context;
        Object paramValue = this.context.getConfiguration().get(OFFSET_PARAM);
        this.logger.debug("Configuring profile with {} parameter '{}'", (Object)OFFSET_PARAM, paramValue);
        if (paramValue instanceof String) {
            try {
                this.offset = new QuantityType((String)paramValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.error("Cannot convert value '{}' of parameter '{}' into a valid offset of type QuantityType.", paramValue, (Object)OFFSET_PARAM);
            }
        } else if (paramValue instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)paramValue;
            this.offset = new QuantityType(bd.toString());
        } else {
            this.logger.error("Parameter '{}' is not of type String or BigDecimal", (Object)OFFSET_PARAM);
        }
    }

    @Override
    public ProfileTypeUID getProfileTypeUID() {
        return SystemProfiles.OFFSET;
    }

    @Override
    public void onStateUpdateFromItem(State state) {
        this.callback.handleUpdate((State)this.applyOffset((Type)state, false));
    }

    @Override
    public void onCommandFromItem(Command command) {
        this.callback.handleCommand((Command)this.applyOffset((Type)command, false));
    }

    @Override
    public void onCommandFromHandler(Command command) {
        this.callback.sendCommand((Command)this.applyOffset((Type)command, true));
    }

    @Override
    public void onStateUpdateFromHandler(State state) {
        this.callback.sendUpdate((State)this.applyOffset((Type)state, true));
    }

    private Type applyOffset(Type state, boolean towardsItem) {
        QuantityType<Temperature> result;
        block12: {
            if (state instanceof UnDefType) {
                return state;
            }
            QuantityType finalOffset = this.offset;
            if (finalOffset == null) {
                this.logger.warn("Offset not configured correctly, please make sure it is of type QuantityType, e.g. \"3\", \"-1.4\", \"3.2\u00b0C\". Using offset 0 now.");
                finalOffset = new QuantityType("0");
            }
            if (!towardsItem) {
                finalOffset = finalOffset.negate();
            }
            result = UnDefType.UNDEF;
            if (state instanceof QuantityType) {
                QuantityType qtState = (QuantityType)state;
                try {
                    if (finalOffset.getUnit() == SmartHomeUnits.ONE) {
                        finalOffset = new QuantityType((Number)finalOffset.toBigDecimal(), qtState.getUnit());
                        this.logger.warn("Received a QuantityType state '{}' with unit, but the offset is defined as a plain number without unit ({}), please consider adding a unit to the profile offset.", (Object)state, this.offset);
                    }
                    if (qtState.getUnit().getSystemUnit().equals(SmartHomeUnits.KELVIN)) {
                        QuantityType<Temperature> tmp = this.handleTemperature((QuantityType<Temperature>)qtState, (QuantityType<Temperature>)finalOffset);
                        if (tmp != null) {
                            result = tmp;
                        }
                        break block12;
                    }
                    result = qtState.add(finalOffset);
                }
                catch (UnconvertibleException unconvertibleException) {
                    this.logger.warn("Cannot apply offset '{}' to state '{}' because types do not match.", (Object)finalOffset, (Object)qtState);
                }
            } else if (state instanceof DecimalType && finalOffset.getUnit().equals(SmartHomeUnits.ONE)) {
                DecimalType decState = (DecimalType)state;
                result = new DecimalType(decState.doubleValue() + finalOffset.doubleValue());
            } else {
                this.logger.warn("Offset '{}' cannot be applied to the incompatible state '{}' sent from the binding. Returning original state.", this.offset, (Object)state);
                result = state;
            }
        }
        return result;
    }

    private @Nullable QuantityType<Temperature> handleTemperature(QuantityType<Temperature> qtState, QuantityType<Temperature> offset) {
        QuantityType kelvinState = qtState.toUnit(SmartHomeUnits.KELVIN);
        QuantityType kelvinOffset = offset.toUnit(SmartHomeUnits.KELVIN);
        QuantityType finalOffset = offset.getUnit().equals(SIUnits.CELSIUS) ? kelvinOffset.add(ZERO_CELSIUS_IN_KELVIN.negate()) : (offset.getUnit().equals(ImperialUnits.FAHRENHEIT) ? kelvinOffset.add(ZERO_FAHRENHEIT_IN_KELVIN.negate()) : offset);
        kelvinState = kelvinState.add(finalOffset);
        return kelvinState.toUnit(qtState.getUnit());
    }
}

