/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.profiles;

import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.DefaultSystemChannelTypeProvider;
import org.eclipse.smarthome.core.thing.internal.profiles.RawButtonToggleSwitchProfile;
import org.eclipse.smarthome.core.thing.internal.profiles.RawRockerDimmerProfile;
import org.eclipse.smarthome.core.thing.internal.profiles.RawRockerOnOffProfile;
import org.eclipse.smarthome.core.thing.internal.profiles.RawRockerPlayPauseProfile;
import org.eclipse.smarthome.core.thing.internal.profiles.SystemDefaultProfile;
import org.eclipse.smarthome.core.thing.internal.profiles.SystemFollowProfile;
import org.eclipse.smarthome.core.thing.internal.profiles.SystemOffsetProfile;
import org.eclipse.smarthome.core.thing.profiles.Profile;
import org.eclipse.smarthome.core.thing.profiles.ProfileAdvisor;
import org.eclipse.smarthome.core.thing.profiles.ProfileCallback;
import org.eclipse.smarthome.core.thing.profiles.ProfileContext;
import org.eclipse.smarthome.core.thing.profiles.ProfileFactory;
import org.eclipse.smarthome.core.thing.profiles.ProfileType;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeProvider;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeUID;
import org.eclipse.smarthome.core.thing.profiles.SystemProfiles;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(service={SystemProfileFactory.class, ProfileTypeProvider.class})
public class SystemProfileFactory
implements ProfileFactory,
ProfileAdvisor,
ProfileTypeProvider {
    @NonNullByDefault(value={})
    private ChannelTypeRegistry channelTypeRegistry;
    private static final Set<ProfileType> SUPPORTED_PROFILE_TYPES = Stream.of(SystemProfiles.DEFAULT_TYPE, SystemProfiles.FOLLOW_TYPE, SystemProfiles.RAWBUTTON_TOGGLE_SWITCH_TYPE, SystemProfiles.RAWROCKER_ON_OFF_TYPE, SystemProfiles.RAWROCKER_DIMMER_TYPE, SystemProfiles.OFFSET_TYPE, SystemProfiles.RAWROCKER_PLAY_PAUSE_TYPE).collect(Collectors.toSet());
    private static final Set<ProfileTypeUID> SUPPORTED_PROFILE_TYPE_UIDS = Stream.of(SystemProfiles.DEFAULT, SystemProfiles.FOLLOW, SystemProfiles.RAWBUTTON_TOGGLE_SWITCH, SystemProfiles.RAWROCKER_ON_OFF, SystemProfiles.RAWROCKER_DIMMER, SystemProfiles.OFFSET, SystemProfiles.RAWROCKER_PLAY_PAUSE).collect(Collectors.toSet());

    @Override
    public @Nullable Profile createProfile(ProfileTypeUID profileTypeUID, ProfileCallback callback, ProfileContext context) {
        if (SystemProfiles.DEFAULT.equals((Object)profileTypeUID)) {
            return new SystemDefaultProfile(callback);
        }
        if (SystemProfiles.FOLLOW.equals((Object)profileTypeUID)) {
            return new SystemFollowProfile(callback);
        }
        if (SystemProfiles.RAWBUTTON_TOGGLE_SWITCH.equals((Object)profileTypeUID)) {
            return new RawButtonToggleSwitchProfile(callback);
        }
        if (SystemProfiles.RAWROCKER_ON_OFF.equals((Object)profileTypeUID)) {
            return new RawRockerOnOffProfile(callback);
        }
        if (SystemProfiles.RAWROCKER_DIMMER.equals((Object)profileTypeUID)) {
            return new RawRockerDimmerProfile(callback, context);
        }
        if (SystemProfiles.RAWROCKER_PLAY_PAUSE.equals((Object)profileTypeUID)) {
            return new RawRockerPlayPauseProfile(callback);
        }
        if (SystemProfiles.OFFSET.equals((Object)profileTypeUID)) {
            return new SystemOffsetProfile(callback, context);
        }
        return null;
    }

    @Override
    public @Nullable ProfileTypeUID getSuggestedProfileTypeUID(@Nullable ChannelType channelType, @Nullable String itemType) {
        if (channelType == null) {
            return null;
        }
        switch (channelType.getKind()) {
            case STATE: {
                return SystemProfiles.DEFAULT;
            }
            case TRIGGER: {
                if (DefaultSystemChannelTypeProvider.SYSTEM_RAWBUTTON.getUID().equals((Object)channelType.getUID())) {
                    if (!"Switch".equalsIgnoreCase(itemType)) break;
                    return SystemProfiles.RAWBUTTON_TOGGLE_SWITCH;
                }
                if (!DefaultSystemChannelTypeProvider.SYSTEM_RAWROCKER.getUID().equals((Object)channelType.getUID())) break;
                if ("Switch".equalsIgnoreCase(itemType)) {
                    return SystemProfiles.RAWROCKER_ON_OFF;
                }
                if ("Dimmer".equalsIgnoreCase(itemType)) {
                    return SystemProfiles.RAWROCKER_DIMMER;
                }
                if (!"Player".equalsIgnoreCase(itemType)) break;
                return SystemProfiles.RAWROCKER_PLAY_PAUSE;
            }
            default: {
                throw new IllegalArgumentException("Unsupported channel kind: " + (Object)((Object)channelType.getKind()));
            }
        }
        return null;
    }

    @Override
    public @Nullable ProfileTypeUID getSuggestedProfileTypeUID(Channel channel, @Nullable String itemType) {
        ChannelType channelType = this.channelTypeRegistry.getChannelType(channel.getChannelTypeUID());
        if (channelType == null) {
            switch (channel.getKind()) {
                case STATE: {
                    return SystemProfiles.DEFAULT;
                }
                case TRIGGER: {
                    return null;
                }
            }
            throw new IllegalArgumentException("Unsupported channel kind: " + (Object)((Object)channel.getKind()));
        }
        return this.getSuggestedProfileTypeUID(channelType, itemType);
    }

    @Override
    public Collection<ProfileType> getProfileTypes(@Nullable Locale locale) {
        return SUPPORTED_PROFILE_TYPES;
    }

    @Override
    public Collection<ProfileTypeUID> getSupportedProfileTypeUIDs() {
        return SUPPORTED_PROFILE_TYPE_UIDS;
    }

    @Reference
    protected void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }
}

