/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.type;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.internal.type.AbstractChannelTypeBuilder;
import org.eclipse.smarthome.core.thing.type.AutoUpdatePolicy;
import org.eclipse.smarthome.core.thing.type.ChannelKind;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.StateChannelTypeBuilder;
import org.eclipse.smarthome.core.types.StateDescription;

@NonNullByDefault
public class StateChannelTypeBuilderImpl
extends AbstractChannelTypeBuilder<StateChannelTypeBuilder>
implements StateChannelTypeBuilder {
    private final String itemType;
    private @Nullable StateDescription stateDescription;
    private @Nullable AutoUpdatePolicy autoUpdatePolicy;

    public StateChannelTypeBuilderImpl(ChannelTypeUID channelTypeUID, String label, String itemType) {
        super(channelTypeUID, label);
        if (StringUtils.isEmpty((String)itemType)) {
            throw new IllegalArgumentException("Supported itemType for a ChannelType must not be empty.");
        }
        this.itemType = itemType;
    }

    @Override
    public StateChannelTypeBuilder withStateDescription(@Nullable StateDescription stateDescription) {
        this.stateDescription = stateDescription;
        return this;
    }

    @Override
    public StateChannelTypeBuilder withAutoUpdatePolicy(@Nullable AutoUpdatePolicy autoUpdatePolicy) {
        this.autoUpdatePolicy = autoUpdatePolicy;
        return this;
    }

    @Override
    public ChannelType build() {
        return new ChannelType(this.channelTypeUID, this.advanced, this.itemType, ChannelKind.STATE, this.label, this.description, this.category, this.tags.isEmpty() ? null : this.tags, this.stateDescription, null, this.configDescriptionURI, this.autoUpdatePolicy);
    }
}

