/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.link;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.common.registry.ManagedProvider;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.link.AbstractLinkRegistry;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkProvider;
import org.eclipse.smarthome.core.thing.link.ManagedItemChannelLinkProvider;
import org.eclipse.smarthome.core.thing.link.events.LinkEventFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={ItemChannelLinkRegistry.class})
public class ItemChannelLinkRegistry
extends AbstractLinkRegistry<ItemChannelLink, ItemChannelLinkProvider> {
    private ThingRegistry thingRegistry;
    private ItemRegistry itemRegistry;

    public ItemChannelLinkRegistry() {
        super(ItemChannelLinkProvider.class);
    }

    public Set<ChannelUID> getBoundChannels(String itemName) {
        return this.getLinks(itemName).parallelStream().map(link -> link.getLinkedUID()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getLinkedItemNames(UID uid) {
        return super.getLinkedItemNames(uid).parallelStream().filter(itemName -> this.itemRegistry.get(itemName) != null).collect(Collectors.toSet());
    }

    public Set<Item> getLinkedItems(UID uid) {
        return super.getLinkedItemNames(uid).parallelStream().map(itemName -> (Item)this.itemRegistry.get(itemName)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<Thing> getBoundThings(String itemName) {
        return this.getBoundChannels(itemName).parallelStream().map(channelUID -> this.thingRegistry.get(channelUID.getThingUID())).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    protected void setManagedProvider(ManagedItemChannelLinkProvider provider) {
        super.setManagedProvider((ManagedProvider)provider);
    }

    protected void unsetManagedProvider(ManagedItemChannelLinkProvider provider) {
        super.unsetManagedProvider((ManagedProvider)provider);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        super.setEventPublisher(eventPublisher);
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        super.unsetEventPublisher(eventPublisher);
    }

    public void removeLinksForThing(ThingUID thingUID) {
        ((ManagedItemChannelLinkProvider)this.getManagedProvider().orElseThrow(() -> new IllegalStateException("ManagedProvider is not available"))).removeLinksForThing(thingUID);
    }

    protected void notifyListenersAboutAddedElement(ItemChannelLink element) {
        super.notifyListenersAboutAddedElement((Identifiable)element);
        this.postEvent((Event)LinkEventFactory.createItemChannelLinkAddedEvent(element));
    }

    protected void notifyListenersAboutRemovedElement(ItemChannelLink element) {
        super.notifyListenersAboutRemovedElement((Identifiable)element);
        this.postEvent((Event)LinkEventFactory.createItemChannelLinkRemovedEvent(element));
    }

    protected void notifyListenersAboutUpdatedElement(ItemChannelLink oldElement, ItemChannelLink element) {
        super.notifyListenersAboutUpdatedElement((Identifiable)oldElement, (Identifiable)element);
    }
}

