/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.type.AutoUpdatePolicy;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

@NonNullByDefault
public class ChannelDefinition {
    private final String id;
    private final ChannelTypeUID channelTypeUID;
    private final Map<String, String> properties;
    private final @Nullable String label;
    private final @Nullable String description;
    private final @Nullable AutoUpdatePolicy autoUpdatePolicy;

    @Deprecated
    public ChannelDefinition(String id, ChannelTypeUID channelTypeUID) throws IllegalArgumentException {
        this(id, channelTypeUID, (String)null, (String)null, (Map<String, String>)null, (AutoUpdatePolicy)null);
    }

    @Deprecated
    public ChannelDefinition(String id, ChannelTypeUID channelTypeUID, @Nullable Map<String, String> properties, @Nullable String label, @Nullable String description) throws IllegalArgumentException {
        this(id, channelTypeUID, label, description, properties, null);
    }

    @Deprecated
    public ChannelDefinition(String id, ChannelTypeUID channelTypeUID, @Nullable Map<String, String> properties, @Nullable String label, @Nullable String description, @Nullable AutoUpdatePolicy autoUpdatePolicy) throws IllegalArgumentException {
        this(id, channelTypeUID, label, description, properties, autoUpdatePolicy);
    }

    ChannelDefinition(String id, ChannelTypeUID channelTypeUID, @Nullable String label, @Nullable String description, @Nullable Map<String, String> properties, @Nullable AutoUpdatePolicy autoUpdatePolicy) throws IllegalArgumentException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("The ID must neither be null nor empty!");
        }
        if (channelTypeUID == null) {
            throw new IllegalArgumentException("The channel type must not be null");
        }
        this.properties = properties != null ? Collections.unmodifiableMap(properties) : Collections.emptyMap();
        this.id = id;
        this.channelTypeUID = channelTypeUID;
        this.label = label;
        this.description = description;
        this.autoUpdatePolicy = autoUpdatePolicy;
    }

    public String getId() {
        return this.id;
    }

    public ChannelTypeUID getChannelTypeUID() {
        return this.channelTypeUID;
    }

    public @Nullable String getLabel() {
        return this.label;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public @Nullable AutoUpdatePolicy getAutoUpdatePolicy() {
        return this.autoUpdatePolicy;
    }

    public String toString() {
        return "ChannelDefinition [id=" + this.id + ", type=" + (Object)((Object)this.channelTypeUID) + ", properties=" + this.properties + "]";
    }
}

