/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;

@NonNullByDefault
public class ChannelGroupTypeBuilder {
    private boolean advanced;
    private @Nullable List<ChannelDefinition> channelDefinitions;
    private @Nullable String category;
    private @Nullable String description;
    private final ChannelGroupTypeUID channelGroupTypeUID;
    private final String label;

    public static ChannelGroupTypeBuilder instance(ChannelGroupTypeUID channelGroupTypeUID, String label) {
        if (channelGroupTypeUID == null) {
            throw new IllegalArgumentException("ChannelGroupTypeUID must be set.");
        }
        if (StringUtils.isEmpty((String)label)) {
            throw new IllegalArgumentException("Label for a ChannelGroupType must not be empty.");
        }
        return new ChannelGroupTypeBuilder(channelGroupTypeUID, label);
    }

    private ChannelGroupTypeBuilder(ChannelGroupTypeUID channelGroupTypeUID, String label) {
        this.channelGroupTypeUID = channelGroupTypeUID;
        this.label = label;
    }

    public ChannelGroupType build() {
        return new ChannelGroupType(this.channelGroupTypeUID, this.advanced, this.label, this.description, this.category, this.channelDefinitions);
    }

    public ChannelGroupTypeBuilder isAdvanced(boolean advanced) {
        this.advanced = advanced;
        return this;
    }

    public ChannelGroupTypeBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ChannelGroupTypeBuilder withCategory(String category) {
        this.category = category;
        return this;
    }

    public ChannelGroupTypeBuilder withChannelDefinitions(List<ChannelDefinition> channelDefinitions) {
        this.channelDefinitions = channelDefinitions;
        return this;
    }
}

