/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.thing.type.AbstractDescriptionType;
import org.eclipse.smarthome.core.thing.type.AutoUpdatePolicy;
import org.eclipse.smarthome.core.thing.type.ChannelKind;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.types.EventDescription;
import org.eclipse.smarthome.core.types.StateDescription;

public class ChannelType
extends AbstractDescriptionType {
    private final boolean advanced;
    private final String itemType;
    private final ChannelKind kind;
    private final Set<String> tags;
    private final String category;
    private final StateDescription state;
    private final EventDescription event;
    private final URI configDescriptionURI;
    private final AutoUpdatePolicy autoUpdatePolicy;

    @Deprecated
    public ChannelType(ChannelTypeUID uid, boolean advanced, String itemType, String label, String description, String category, Set<String> tags, StateDescription state, URI configDescriptionURI) {
        this(uid, advanced, itemType, ChannelKind.STATE, label, description, category, tags, state, null, configDescriptionURI);
    }

    @Deprecated
    public ChannelType(ChannelTypeUID uid, boolean advanced, String itemType, ChannelKind kind, String label, String description, String category, Set<String> tags, StateDescription state, EventDescription event, URI configDescriptionURI) throws IllegalArgumentException {
        this(uid, advanced, itemType, kind, label, description, category, tags, state, event, configDescriptionURI, null);
    }

    public ChannelType(ChannelTypeUID uid, boolean advanced, String itemType, ChannelKind kind, String label, String description, String category, Set<String> tags, StateDescription state, EventDescription event, URI configDescriptionURI, AutoUpdatePolicy autoUpdatePolicy) throws IllegalArgumentException {
        super(uid, label, description);
        if (kind == null) {
            throw new IllegalArgumentException("Kind must not be null!");
        }
        if (kind == ChannelKind.STATE && StringUtils.isBlank((String)itemType)) {
            throw new IllegalArgumentException("If the kind is 'state', the item type must be set!");
        }
        if (kind == ChannelKind.TRIGGER && itemType != null) {
            throw new IllegalArgumentException("If the kind is 'trigger', the item type must not be set!");
        }
        this.itemType = itemType;
        this.kind = kind;
        this.configDescriptionURI = configDescriptionURI;
        this.tags = tags != null ? Collections.unmodifiableSet(new HashSet<String>(tags)) : Collections.unmodifiableSet(new HashSet(0));
        this.advanced = advanced;
        this.category = category;
        this.state = state;
        this.event = event;
        this.autoUpdatePolicy = autoUpdatePolicy;
    }

    @Override
    public ChannelTypeUID getUID() {
        return (ChannelTypeUID)super.getUID();
    }

    public String getItemType() {
        return this.itemType;
    }

    public ChannelKind getKind() {
        return this.kind;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return super.getUID().toString();
    }

    public URI getConfigDescriptionURI() {
        return this.configDescriptionURI;
    }

    public StateDescription getState() {
        return this.state;
    }

    public EventDescription getEvent() {
        return this.event;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public String getCategory() {
        return this.category;
    }

    public AutoUpdatePolicy getAutoUpdatePolicy() {
        return this.autoUpdatePolicy;
    }
}

