/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.transform;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractFileTransformationService<T>
implements TransformationService {
    private @Nullable WatchService watchService = null;
    protected final Map<String, T> cachedFiles = new ConcurrentHashMap<String, T>();
    protected final List<String> watchedDirectories = new ArrayList<String>();
    private final Logger logger = LoggerFactory.getLogger(AbstractFileTransformationService.class);
    @NonNullByDefault(value={})
    private LocaleProvider localeProvider;
    @NonNullByDefault(value={})
    private ServiceTracker<LocaleProvider, LocaleProvider> localeProviderTracker;

    protected void activate(BundleContext context) {
        this.localeProviderTracker = new ServiceTracker(context, LocaleProvider.class, (ServiceTrackerCustomizer)new LocaleProviderServiceTrackerCustomizer(context));
        this.localeProviderTracker.open();
    }

    protected void deactivate() {
        this.localeProviderTracker.close();
    }

    protected Locale getLocale() {
        return this.localeProvider.getLocale();
    }

    @Override
    public @Nullable String transform(String filename, String source) throws TransformationException {
        if (filename == null || source == null) {
            throw new TransformationException("the given parameters 'filename' and 'source' must not be null");
        }
        WatchService watchService = this.getWatchService();
        this.processFolderEvents(watchService);
        String transformFile = this.getLocalizedProposedFilename(filename, watchService);
        T transform = this.cachedFiles.get(transformFile);
        if (transform == null) {
            transform = this.internalLoadTransform(transformFile);
            this.cachedFiles.put(transformFile, transform);
        }
        try {
            return this.internalTransform(transform, source);
        }
        catch (TransformationException e) {
            this.logger.warn("Could not transform '{}' with the file '{}' : {}", new Object[]{source, filename, e.getMessage()});
            return "";
        }
    }

    protected abstract String internalTransform(T var1, String var2) throws TransformationException;

    protected abstract T internalLoadTransform(String var1) throws TransformationException;

    private synchronized WatchService getWatchService() throws TransformationException {
        WatchService watchService = this.watchService;
        if (watchService != null) {
            return watchService;
        }
        try {
            watchService = this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException iOException) {
            this.logger.error("Unable to start transformation directory monitoring");
            throw new TransformationException("Cannot get a new watch service.");
        }
        this.watchSubDirectory("", watchService);
        return watchService;
    }

    private void watchSubDirectory(String subDirectory, WatchService watchService) {
        if (this.watchedDirectories.indexOf(subDirectory) == -1) {
            String watchedDirectory = String.valueOf(this.getSourcePath()) + subDirectory;
            Path transformFilePath = Paths.get(watchedDirectory, new String[0]);
            try {
                transformFilePath.register(watchService, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                this.logger.debug("Watching directory {}", (Object)transformFilePath);
                this.watchedDirectories.add(subDirectory);
            }
            catch (IOException iOException) {
                this.logger.warn("Unable to watch transformation directory : {}", (Object)watchedDirectory);
                this.cachedFiles.clear();
            }
        }
    }

    private void processFolderEvents(WatchService watchService) {
        WatchKey key = watchService.poll();
        if (key != null) {
            for (WatchEvent<?> e : key.pollEvents()) {
                if (e.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> ev = e;
                Path path = (Path)ev.context();
                this.logger.debug("Refreshing transformation file '{}'", (Object)path);
                for (String fileEntry : this.cachedFiles.keySet()) {
                    if (!fileEntry.endsWith(path.toString())) continue;
                    this.cachedFiles.remove(fileEntry);
                }
            }
            key.reset();
        }
    }

    protected String getLocalizedProposedFilename(String filename, WatchService watchService) {
        String extension = FilenameUtils.getExtension((String)filename);
        String prefix = FilenameUtils.getPath((String)filename);
        String result = filename;
        if (!prefix.isEmpty()) {
            this.watchSubDirectory(prefix, watchService);
        }
        if (!filename.matches(".*_[a-z]{2}." + extension + "$")) {
            String basename = FilenameUtils.getBaseName((String)filename);
            String alternateName = String.valueOf(prefix) + basename + "_" + this.getLocale().getLanguage() + "." + extension;
            String alternatePath = String.valueOf(this.getSourcePath()) + alternateName;
            File f = new File(alternatePath);
            if (f.exists()) {
                result = alternateName;
            }
        }
        result = String.valueOf(this.getSourcePath()) + result;
        return result;
    }

    protected String getSourcePath() {
        return String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + "transform" + File.separator;
    }

    private class LocaleProviderServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<LocaleProvider, LocaleProvider> {
        private final BundleContext context;

        public LocaleProviderServiceTrackerCustomizer(BundleContext context) {
            this.context = context;
        }

        public LocaleProvider addingService(@Nullable ServiceReference<LocaleProvider> reference) {
            AbstractFileTransformationService.this.localeProvider = (LocaleProvider)this.context.getService(reference);
            return AbstractFileTransformationService.this.localeProvider;
        }

        public void modifiedService(@Nullable ServiceReference<LocaleProvider> reference, LocaleProvider service) {
        }

        public void removedService(@Nullable ServiceReference<LocaleProvider> reference, LocaleProvider service) {
            AbstractFileTransformationService.this.localeProvider = null;
        }
    }
}

