/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common.registry;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.common.registry.AbstractProvider;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.common.registry.ManagedProvider;
import org.eclipse.smarthome.core.storage.Storage;
import org.eclipse.smarthome.core.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManagedProvider<E extends Identifiable<K>, K, PE>
extends AbstractProvider<E>
implements ManagedProvider<E, K> {
    private StorageService storageService;
    private volatile Storage<PE> storage;
    protected final Logger logger = LoggerFactory.getLogger(AbstractManagedProvider.class);

    @Override
    public void add(E element) {
        String keyAsString = this.getKeyAsString(element);
        if (this.storage.get(keyAsString) != null) {
            throw new IllegalArgumentException("Cannot add element, because an element with same UID (" + keyAsString + ") already exists.");
        }
        this.storage.put(keyAsString, this.toPersistableElement(element));
        this.notifyListenersAboutAddedElement(element);
        this.logger.debug("Added new element {} to {}.", (Object)keyAsString, (Object)this.getClass().getSimpleName());
    }

    @Override
    public Collection<E> getAll() {
        return this.storage.getKeys().stream().map(key -> {
            PE persistableElement = this.storage.get((String)key);
            if (persistableElement != null) {
                return this.toElement((String)key, persistableElement);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public E get(K key) {
        if (key == null) {
            throw new IllegalArgumentException("Cannot get null element");
        }
        String keyAsString = this.keyToString(key);
        PE persistableElement = this.storage.get(keyAsString);
        if (persistableElement != null) {
            return this.toElement(keyAsString, persistableElement);
        }
        return null;
    }

    @Override
    public E remove(K key) {
        E element;
        String keyAsString = this.keyToString(key);
        PE persistableElement = this.storage.remove(keyAsString);
        if (persistableElement != null && (element = this.toElement(keyAsString, persistableElement)) != null) {
            this.notifyListenersAboutRemovedElement(element);
            this.logger.debug("Removed element {} from {}.", (Object)keyAsString, (Object)this.getClass().getSimpleName());
            return element;
        }
        return null;
    }

    @Override
    public E update(E element) {
        String key = this.getKeyAsString(element);
        if (this.storage.get(key) != null) {
            PE persistableElement = this.storage.put(key, this.toPersistableElement(element));
            if (persistableElement != null) {
                E oldElement = this.toElement(key, persistableElement);
                this.notifyListenersAboutUpdatedElement(oldElement, element);
                this.logger.debug("Updated element {} in {}.", (Object)key, (Object)this.getClass().getSimpleName());
                return oldElement;
            }
        } else {
            this.logger.warn("Could not update element with key {} in {}, because it does not exists.", (Object)key, (Object)this.getClass().getSimpleName());
        }
        return null;
    }

    private @NonNull String getKeyAsString(@NonNull E element) {
        return this.keyToString(element.getUID());
    }

    protected abstract String getStorageName();

    protected abstract @NonNull String keyToString(@NonNull K var1);

    protected void setStorageService(StorageService storageService) {
        if (this.storageService != storageService) {
            this.storageService = storageService;
            this.storage = storageService.getStorage(this.getStorageName(), this.getClass().getClassLoader());
        }
    }

    protected void unsetStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
            this.storage = null;
        }
    }

    protected abstract E toElement(@NonNull String var1, @NonNull PE var2);

    protected abstract PE toPersistableElement(E var1);
}

