/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.i18n;

import java.text.MessageFormat;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Length;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.spi.SystemOfUnits;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.LocationProvider;
import org.eclipse.smarthome.core.i18n.TimeZoneProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.i18n.UnitProvider;
import org.eclipse.smarthome.core.internal.i18n.LanguageResourceBundleManager;
import org.eclipse.smarthome.core.internal.i18n.ResourceBundleTracker;
import org.eclipse.smarthome.core.library.dimension.Intensity;
import org.eclipse.smarthome.core.library.types.PointType;
import org.eclipse.smarthome.core.library.unit.ImperialUnits;
import org.eclipse.smarthome.core.library.unit.MetricPrefix;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, configurationPid="org.eclipse.smarthome.core.i18nprovider", property={"service.pid=org.eclipse.smarthome.core.i18nprovider", "service.config.description.uri:String=system:i18n", "service.config.label:String=Regional Settings", "service.config.category:String=system"})
public class I18nProviderImpl
implements TranslationProvider,
LocaleProvider,
LocationProvider,
TimeZoneProvider,
UnitProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    static final String LANGUAGE = "language";
    static final String SCRIPT = "script";
    static final String REGION = "region";
    static final String VARIANT = "variant";
    private @Nullable Locale locale;
    @NonNullByDefault(value={})
    private ResourceBundleTracker resourceBundleTracker;
    static final String LOCATION = "location";
    private @Nullable PointType location;
    static final String TIMEZONE = "timezone";
    private @Nullable ZoneId timeZone;
    private static final String MEASUREMENT_SYSTEM = "measurementSystem";
    private @Nullable SystemOfUnits measurementSystem;
    private final Map<Class<? extends Quantity<?>>, Map<SystemOfUnits, Unit<? extends Quantity<?>>>> dimensionMap = new HashMap();

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.initDimensionMap();
        this.modified((Map)((Object)componentContext.getProperties()));
        this.resourceBundleTracker = new ResourceBundleTracker(componentContext.getBundleContext(), this);
        this.resourceBundleTracker.open();
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.resourceBundleTracker.close();
    }

    @Modified
    protected synchronized void modified(Map<String, Object> config) {
        String language = this.toStringOrNull(config.get(LANGUAGE));
        String script = this.toStringOrNull(config.get(SCRIPT));
        String region = this.toStringOrNull(config.get(REGION));
        String variant = this.toStringOrNull(config.get(VARIANT));
        String location = this.toStringOrNull(config.get(LOCATION));
        String zoneId = this.toStringOrNull(config.get(TIMEZONE));
        String measurementSystem = this.toStringOrNull(config.get(MEASUREMENT_SYSTEM));
        this.setTimeZone(zoneId);
        this.setLocation(location);
        this.setLocale(language, script, region, variant);
        this.setMeasurementSystem(measurementSystem);
    }

    private void setMeasurementSystem(@Nullable String measurementSystem) {
        SystemOfUnits newMeasurementSystem;
        SystemOfUnits oldMeasurementSystem = this.measurementSystem;
        String ms = measurementSystem == null || measurementSystem.isEmpty() ? "" : measurementSystem;
        switch (ms) {
            case "SI": {
                newMeasurementSystem = SIUnits.getInstance();
                break;
            }
            case "US": {
                newMeasurementSystem = ImperialUnits.getInstance();
                break;
            }
            default: {
                this.logger.debug("Error setting measurement system for value '{}'.", (Object)measurementSystem);
                newMeasurementSystem = null;
            }
        }
        this.measurementSystem = newMeasurementSystem;
        if (oldMeasurementSystem != null && newMeasurementSystem == null) {
            this.logger.info("Measurement system is not set, falling back to locale based system.");
        } else if (newMeasurementSystem != null && !newMeasurementSystem.equals(oldMeasurementSystem)) {
            this.logger.info("Measurement system set to '{}'.", (Object)newMeasurementSystem.getName());
        }
    }

    private void setLocale(@Nullable String language, @Nullable String script, @Nullable String region, @Nullable String variant) {
        Locale newLocale;
        Locale oldLocale = this.locale;
        if (StringUtils.isEmpty((String)language)) {
            this.logger.debug("No language set, setting locale to 'null'.");
            this.locale = null;
            if (oldLocale != null) {
                this.logger.info("Locale is not set, falling back to the default locale");
            }
            return;
        }
        Locale.Builder builder = new Locale.Builder();
        try {
            builder.setLanguage(language);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Language ({}) is invalid. Cannot create locale, keep old one.", (Object)language, (Object)ex);
            return;
        }
        try {
            builder.setScript(script);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Script ({}) is invalid. Skip it.", (Object)script, (Object)ex);
            return;
        }
        try {
            builder.setRegion(region);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Region ({}) is invalid. Skip it.", (Object)region, (Object)ex);
            return;
        }
        try {
            builder.setVariant(variant);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Variant ({}) is invalid. Skip it.", (Object)variant, (Object)ex);
            return;
        }
        this.locale = newLocale = builder.build();
        if (!newLocale.equals(oldLocale)) {
            this.logger.info("Locale set to '{}'.", (Object)newLocale);
        }
    }

    private @Nullable String toStringOrNull(@Nullable Object value) {
        return value == null ? null : value.toString();
    }

    private void setLocation(@Nullable String location) {
        PointType newLocation;
        PointType oldLocation = this.location;
        if (location == null || location.isEmpty()) {
            newLocation = null;
        } else {
            try {
                newLocation = PointType.valueOf(location);
            }
            catch (IllegalArgumentException e) {
                newLocation = oldLocation;
                this.logger.warn("Could not set new location: {}, keeping old one, error message: {}", (Object)location, (Object)e.getMessage());
            }
        }
        if (!Objects.equals(newLocation, oldLocation)) {
            this.location = newLocation;
            this.logger.info("Location set to '{}'.", (Object)newLocation);
        }
    }

    private void setTimeZone(@Nullable String zoneId) {
        ZoneId oldTimeZone = this.timeZone;
        if (StringUtils.isBlank((String)zoneId)) {
            this.timeZone = null;
        } else {
            try {
                this.timeZone = ZoneId.of(zoneId);
            }
            catch (DateTimeException e) {
                this.logger.warn("Error setting time zone '{}', falling back to the default time zone: {}", (Object)zoneId, (Object)e.getMessage());
                this.timeZone = null;
            }
        }
        if (oldTimeZone != null && this.timeZone == null) {
            this.logger.info("Time zone is not set, falling back to the default time zone.");
        } else if (this.timeZone != null && !this.timeZone.equals(oldTimeZone)) {
            this.logger.info("Time zone set to '{}'.", (Object)this.timeZone);
        }
    }

    @Override
    public @Nullable PointType getLocation() {
        return this.location;
    }

    @Override
    public ZoneId getTimeZone() {
        ZoneId timeZone = this.timeZone;
        if (timeZone == null) {
            return TimeZone.getDefault().toZoneId();
        }
        return timeZone;
    }

    @Override
    public Locale getLocale() {
        Locale locale = this.locale;
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }

    @Override
    public @Nullable String getText(@Nullable Bundle bundle, @Nullable String key, @Nullable String defaultText, @Nullable Locale locale) {
        String text;
        LanguageResourceBundleManager languageResource = this.resourceBundleTracker.getLanguageResource(bundle);
        if (languageResource != null && (text = languageResource.getText(key, locale)) != null) {
            return text;
        }
        return defaultText;
    }

    @Override
    public @Nullable String getText(@Nullable Bundle bundle, @Nullable String key, @Nullable String defaultText, @Nullable Locale locale, Object ... arguments) {
        String text = this.getText(bundle, key, defaultText, locale);
        if (text != null) {
            return MessageFormat.format(text, arguments);
        }
        return text;
    }

    @Override
    public <T extends Quantity<T>> @Nullable Unit<T> getUnit(@Nullable Class<T> dimension) {
        Map<SystemOfUnits, Unit<Quantity<?>>> map = this.dimensionMap.get(dimension);
        if (map == null) {
            return null;
        }
        return map.get(this.getMeasurementSystem());
    }

    @Override
    public SystemOfUnits getMeasurementSystem() {
        SystemOfUnits measurementSystem = this.measurementSystem;
        if (measurementSystem != null) {
            return measurementSystem;
        }
        if (Locale.US.equals(this.locale) || Locale.forLanguageTag("en-LR").equals(this.locale)) {
            return ImperialUnits.getInstance();
        }
        return SIUnits.getInstance();
    }

    private void initDimensionMap() {
        HashMap<SystemOfUnits, Unit<Temperature>> temperatureMap = new HashMap<SystemOfUnits, Unit<Temperature>>();
        temperatureMap.put(SIUnits.getInstance(), SIUnits.CELSIUS);
        temperatureMap.put(ImperialUnits.getInstance(), ImperialUnits.FAHRENHEIT);
        this.dimensionMap.put(Temperature.class, temperatureMap);
        HashMap<SystemOfUnits, Unit<Pressure>> pressureMap = new HashMap<SystemOfUnits, Unit<Pressure>>();
        pressureMap.put(SIUnits.getInstance(), MetricPrefix.HECTO(SIUnits.PASCAL));
        pressureMap.put(ImperialUnits.getInstance(), ImperialUnits.INCH_OF_MERCURY);
        this.dimensionMap.put(Pressure.class, pressureMap);
        HashMap<SystemOfUnits, Unit<Speed>> speedMap = new HashMap<SystemOfUnits, Unit<Speed>>();
        speedMap.put(SIUnits.getInstance(), SIUnits.KILOMETRE_PER_HOUR);
        speedMap.put(ImperialUnits.getInstance(), ImperialUnits.MILES_PER_HOUR);
        this.dimensionMap.put(Speed.class, speedMap);
        HashMap<SystemOfUnits, Unit<Length>> lengthMap = new HashMap<SystemOfUnits, Unit<Length>>();
        lengthMap.put(SIUnits.getInstance(), SIUnits.METRE);
        lengthMap.put(ImperialUnits.getInstance(), ImperialUnits.INCH);
        this.dimensionMap.put(Length.class, lengthMap);
        HashMap<SystemOfUnits, Unit<Intensity>> intensityMap = new HashMap<SystemOfUnits, Unit<Intensity>>();
        intensityMap.put(SIUnits.getInstance(), SmartHomeUnits.IRRADIANCE);
        intensityMap.put(ImperialUnits.getInstance(), SmartHomeUnits.IRRADIANCE);
        this.dimensionMap.put(Intensity.class, intensityMap);
        HashMap<SystemOfUnits, Unit<Dimensionless>> percentMap = new HashMap<SystemOfUnits, Unit<Dimensionless>>();
        percentMap.put(SIUnits.getInstance(), SmartHomeUnits.ONE);
        percentMap.put(ImperialUnits.getInstance(), SmartHomeUnits.ONE);
        this.dimensionMap.put(Dimensionless.class, percentMap);
        HashMap<SystemOfUnits, Unit<Angle>> angleMap = new HashMap<SystemOfUnits, Unit<Angle>>();
        angleMap.put(SIUnits.getInstance(), SmartHomeUnits.DEGREE_ANGLE);
        angleMap.put(ImperialUnits.getInstance(), SmartHomeUnits.DEGREE_ANGLE);
        this.dimensionMap.put(Angle.class, angleMap);
    }
}

