/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.scheduler;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.scheduler.AbstractExpression;
import org.eclipse.smarthome.core.scheduler.AbstractExpressionPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecurrenceExpression
extends AbstractExpression<RecurrenceExpressionPart> {
    private static final String FREQ = "FREQ";
    private static final String UNTIL = "UNTIL";
    private static final String COUNT = "COUNT";
    private static final String INTERVAL = "INTERVAL";
    private static final String BYSECOND = "BYSECOND";
    private static final String BYMINUTE = "BYMINUTE";
    private static final String BYHOUR = "BYHOUR";
    private static final String BYDAY = "BYDAY";
    private static final String BYMONTHDAY = "BYMONTHDAY";
    private static final String BYYEARDAY = "BYYEARDAY";
    private static final String BYWEEKNO = "BYWEEKNO";
    private static final String BYMONTH = "BYMONTH";
    private static final String BYSETPOS = "BYSETPOS";
    private static final String WKST = "WKST";
    private final Logger logger = LoggerFactory.getLogger(RecurrenceExpression.class);

    public RecurrenceExpression(String recurrenceRule) throws ParseException {
        this(recurrenceRule, Calendar.getInstance().getTime(), TimeZone.getDefault());
    }

    public RecurrenceExpression(String recurrenceRule, Date startTime) throws ParseException {
        this(recurrenceRule, startTime, TimeZone.getDefault());
    }

    public RecurrenceExpression(String recurrenceRule, Date startTime, TimeZone zone) throws ParseException {
        super(recurrenceRule, ";", startTime, zone, 0, 366);
    }

    @Override
    public void setStartDate(Date startDate) throws IllegalArgumentException, ParseException {
        if (startDate == null) {
            throw new IllegalArgumentException("The start date of the rule can not be null");
        }
        UntilExpressionPart until = this.getExpressionPart(UntilExpressionPart.class);
        if (until != null && until.getUntil().before(startDate)) {
            throw new IllegalArgumentException("Start date cannot be after until");
        }
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setTime(startDate);
        if (calendar.get(14) != 0) {
            calendar.add(13, 1);
            calendar.set(14, 0);
        }
        super.setStartDate(calendar.getTime());
    }

    @Override
    public boolean isSatisfiedBy(Date test) {
        this.getTimeAfter(test);
        Collections.sort(this.getCandidates());
        for (Date aDate : this.getCandidates()) {
            if (aDate.after(test)) {
                return false;
            }
            if (!aDate.equals(test)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidExpression(String expression) {
        try {
            new RecurrenceExpression(expression);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    @Override
    public final Date getFinalFireTime() {
        boolean isCount;
        boolean isUntil = this.getExpressionPart(UntilExpressionPart.class) != null;
        boolean bl = isCount = this.getExpressionPart(CountExpressionPart.class) != null;
        if (!isUntil && !isCount) {
            return null;
        }
        return super.getFinalFireTime();
    }

    @Override
    protected void validateExpression() throws IllegalArgumentException {
        Frequency frequency;
        boolean isByMonth;
        boolean isFrequency = this.getExpressionPart(FrequencyExpressionPart.class) != null;
        boolean isUntil = this.getExpressionPart(UntilExpressionPart.class) != null;
        boolean isCount = this.getExpressionPart(CountExpressionPart.class) != null;
        boolean isByDay = this.getExpressionPart(DayExpressionPart.class) != null;
        boolean isByWeekNumber = this.getExpressionPart(WeekNumberExpressionPart.class) != null;
        boolean isByMonthDay = this.getExpressionPart(MonthDayExpressionPart.class) != null;
        boolean isByYearDay = this.getExpressionPart(YearDayExpressionPart.class) != null;
        boolean isByPosition = this.getExpressionPart(PositionExpressionPart.class) != null;
        boolean isBySecond = this.getExpressionPart(SecondExpressionPart.class) != null;
        boolean isByHour = this.getExpressionPart(HourExpressionPart.class) != null;
        boolean isByMinute = this.getExpressionPart(MinuteExpressionPart.class) != null;
        boolean bl = isByMonth = this.getExpressionPart(MonthExpressionPart.class) != null;
        if (!isFrequency) {
            throw new IllegalArgumentException("A recurrence rule MUST contain a FREQ rule part.");
        }
        if (isUntil && isCount) {
            throw new IllegalArgumentException("The UNTIL and COUNT rule parts MUST NOT occur in the same recurrence rule.");
        }
        if (isByDay && isFrequency) {
            frequency = this.getExpressionPart(FrequencyExpressionPart.class).getFrequency();
            if (this.getExpressionPart(DayExpressionPart.class).isNumeric() && (frequency == Frequency.MONTHLY || frequency == Frequency.YEARLY)) {
                throw new IllegalArgumentException("The BYDAY rule part MUST NOT be specified with a numeric value when the FREQ rule part is not set to MONTHLY or YEARLY.");
            }
        }
        if (isByDay && isFrequency && isByWeekNumber) {
            frequency = this.getExpressionPart(FrequencyExpressionPart.class).getFrequency();
            if (this.getExpressionPart(DayExpressionPart.class).isNumeric() && frequency == Frequency.YEARLY) {
                throw new IllegalArgumentException("The BYDAY rule part MUST NOT be specified with a numeric value with the FREQ rule part set to YEARLY when the BYWEEKNO rule part is specified.");
            }
        }
        if (isByMonthDay && isFrequency && (frequency = this.getExpressionPart(FrequencyExpressionPart.class).getFrequency()) == Frequency.WEEKLY) {
            throw new IllegalArgumentException("The BYMONTHDAY rule part MUST NOT be specified when the FREQ rule part is set to WEEKLY.");
        }
        if (isByYearDay && isFrequency && ((frequency = this.getExpressionPart(FrequencyExpressionPart.class).getFrequency()) == Frequency.WEEKLY || frequency == Frequency.DAILY || frequency == Frequency.MONTHLY)) {
            throw new IllegalArgumentException("The BYYEARDAY rule part MUST NOT be specified when the FREQ rule part is set to DAILY, WEEKLY, or MONTHLY.");
        }
        if (isByWeekNumber && isFrequency && (frequency = this.getExpressionPart(FrequencyExpressionPart.class).getFrequency()) != Frequency.YEARLY) {
            throw new IllegalArgumentException("The BYWEEKNO rule part MUST NOT be used when the FREQ rule part is set to anything other than YEARLY.");
        }
        if (!(!isByPosition || isByDay || isByHour || isByMinute || isByMonth || isByMonthDay || isBySecond || isByWeekNumber || isByYearDay)) {
            throw new IllegalArgumentException("The BYSETPOS rule part MUST only be used in conjunction with another BYxxx rule part.");
        }
    }

    @Override
    protected void populateWithSeeds() {
    }

    @Override
    protected void pruneFarthest() {
        Collections.sort(this.getCandidates());
        ArrayList<Date> beforeDates = new ArrayList<Date>();
        for (Date candidate : this.getCandidates()) {
            if (!candidate.before(this.getStartDate())) continue;
            beforeDates.add(candidate);
        }
        this.getCandidates().removeAll(beforeDates);
    }

    @Override
    protected RecurrenceExpressionPart parseToken(String token, int position) throws ParseException {
        String key = StringUtils.substringBefore((String)token, (String)"=");
        String value = StringUtils.substringAfter((String)token, (String)"=");
        switch (key) {
            case "FREQ": {
                return new FrequencyExpressionPart(value);
            }
            case "INTERVAL": {
                return new IntervalExpressionPart(value);
            }
            case "BYSECOND": {
                return new SecondExpressionPart(value);
            }
            case "BYMINUTE": {
                return new MinuteExpressionPart(value);
            }
            case "BYHOUR": {
                return new HourExpressionPart(value);
            }
            case "BYDAY": {
                return new DayExpressionPart(value);
            }
            case "BYMONTHDAY": {
                return new MonthDayExpressionPart(value);
            }
            case "BYMONTH": {
                return new MonthExpressionPart(value);
            }
            case "BYYEARDAY": {
                return new YearDayExpressionPart(value);
            }
            case "BYWEEKNO": {
                return new WeekNumberExpressionPart(value);
            }
            case "BYSETPOS": {
                return new PositionExpressionPart(value);
            }
            case "WKST": {
                return new WeekStartExpressionPart(value);
            }
            case "UNTIL": {
                return new UntilExpressionPart(value);
            }
            case "COUNT": {
                return new CountExpressionPart(value);
            }
        }
        throw new IllegalArgumentException("Unknown expression part");
    }

    @Override
    public boolean hasFloatingStartDate() {
        return false;
    }

    public class CountExpressionPart
    extends RecurrenceExpressionPart {
        int count;

        public CountExpressionPart(String s) throws ParseException {
            super(s);
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void parse() throws ParseException {
            try {
                this.count = Integer.parseInt(this.getPart());
                if (this.count <= 0) {
                    throw new IllegalArgumentException("Count must be a postive integer");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Invalid integer value for COUNT : " + this.getPart(), 0);
            }
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            ArrayList<Date> countedCandidates = new ArrayList<Date>();
            Collections.sort(candidates);
            int maxToCount = Math.min(candidates.size(), this.count);
            int i = 0;
            while (i < maxToCount) {
                countedCandidates.add(candidates.get(i));
                ++i;
            }
            return countedCandidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return null;
        }

        @Override
        public int order() {
            return 13;
        }
    }

    public class DayExpressionPart
    extends DayListRecurrenceExpressionPart {
        protected static final int MIN_MONTHDAY = 1;
        protected static final int MAX_MONTHDAY = 31;

        public DayExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            boolean isByMonth;
            FrequencyExpressionPart freqpart = RecurrenceExpression.this.getExpressionPart(FrequencyExpressionPart.class);
            Frequency frequency = freqpart.getFrequency();
            WeekStartExpressionPart weekStartPart = RecurrenceExpression.this.getExpressionPart(WeekStartExpressionPart.class);
            WeekDay weekStart = weekStartPart != null ? weekStartPart.getWeekStart() : WeekDay.MONDAY;
            boolean isByYearDay = RecurrenceExpression.this.getExpressionPart(YearDayExpressionPart.class) != null;
            boolean isByMonthDay = RecurrenceExpression.this.getExpressionPart(MonthDayExpressionPart.class) != null;
            boolean isByWeekNumber = RecurrenceExpression.this.getExpressionPart(WeekNumberExpressionPart.class) != null;
            boolean bl = isByMonth = RecurrenceExpression.this.getExpressionPart(MonthExpressionPart.class) != null;
            if (frequency == Frequency.YEARLY) {
                if (isByYearDay || isByMonthDay) {
                    ArrayList<Date> pruneCandidates = new ArrayList<Date>();
                    Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                    for (Date aDate : candidates) {
                        cal.setTime(aDate);
                        if (this.dayList.keySet().contains((Object)WeekDay.getWeekDay(cal.get(7) - 1))) continue;
                        pruneCandidates.add(aDate);
                    }
                    candidates.removeAll(pruneCandidates);
                } else if (isByWeekNumber) {
                    ArrayList<Date> newCandidates = new ArrayList<Date>();
                    List<Date> oldCandidates = candidates;
                    Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                    for (Date date : candidates) {
                        for (WeekDay aDay : this.dayList.keySet()) {
                            cal.setTime(date);
                            cal.setFirstDayOfWeek(weekStart.getCalendarDay());
                            cal.set(7, aDay.getCalendarDay());
                            newCandidates.add(cal.getTime());
                        }
                    }
                    candidates.removeAll(oldCandidates);
                    candidates.addAll(newCandidates);
                } else if (isByMonth) {
                    ArrayList<Date> newCandidates = new ArrayList<Date>();
                    List<Date> oldCandidates = candidates;
                    Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                    for (Date date : candidates) {
                        for (WeekDay aDay : this.dayList.keySet()) {
                            cal.setTime(date);
                            cal.set(5, 1);
                            ArrayList<Date> datesInMonth = new ArrayList<Date>();
                            int setMonth = cal.get(2);
                            while (cal.get(5) <= cal.getMaximum(5) && cal.get(2) == setMonth) {
                                if (cal.get(7) == aDay.getCalendarDay()) {
                                    datesInMonth.add(cal.getTime());
                                }
                                cal.add(6, 1);
                            }
                            cal.setTime(date);
                            RecurrenceExpression.this.logger.debug("date is {}, weekday is {}, offset is {}, datesInMonth {}", new Object[]{date, aDay, this.dayList.get((Object)aDay), datesInMonth.size()});
                            if ((Integer)this.dayList.get((Object)aDay) > 0 && (Integer)this.dayList.get((Object)aDay) <= datesInMonth.size()) {
                                newCandidates.add((Date)datesInMonth.get((Integer)this.dayList.get((Object)aDay) - 1));
                                continue;
                            }
                            if ((Integer)this.dayList.get((Object)aDay) < 0 && (Integer)this.dayList.get((Object)aDay) >= -datesInMonth.size()) {
                                RecurrenceExpression.this.logger.debug("Adding new candidate {}", datesInMonth.get(datesInMonth.size() + (Integer)this.dayList.get((Object)aDay)));
                                newCandidates.add((Date)datesInMonth.get(datesInMonth.size() + (Integer)this.dayList.get((Object)aDay)));
                                continue;
                            }
                            if ((Integer)this.dayList.get((Object)aDay) != 0) continue;
                            newCandidates.addAll(datesInMonth);
                        }
                    }
                    candidates.removeAll(oldCandidates);
                    candidates.addAll(newCandidates);
                } else {
                    ArrayList<Date> newCandidates = new ArrayList<Date>();
                    List<Date> oldCandidates = candidates;
                    Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                    for (Date date : candidates) {
                        for (WeekDay aDay : this.dayList.keySet()) {
                            cal.setTime(date);
                            cal.set(2, 0);
                            cal.set(5, 1);
                            int setYear = cal.get(1);
                            ArrayList<Date> datesInYear = new ArrayList<Date>();
                            while (cal.get(6) <= cal.getMaximum(6) && cal.get(1) == setYear) {
                                if (cal.get(7) == aDay.getCalendarDay()) {
                                    datesInYear.add(cal.getTime());
                                }
                                cal.add(6, 1);
                            }
                            cal.setTime(date);
                            if ((Integer)this.dayList.get((Object)aDay) > 0 && (Integer)this.dayList.get((Object)aDay) <= datesInYear.size()) {
                                newCandidates.add((Date)datesInYear.get((Integer)this.dayList.get((Object)aDay) - 1));
                                continue;
                            }
                            if ((Integer)this.dayList.get((Object)aDay) < 0 && (Integer)this.dayList.get((Object)aDay) >= -datesInYear.size()) {
                                newCandidates.add((Date)datesInYear.get(datesInYear.size() + (Integer)this.dayList.get((Object)aDay)));
                                continue;
                            }
                            if ((Integer)this.dayList.get((Object)aDay) != 0) continue;
                            newCandidates.addAll(datesInYear);
                        }
                    }
                    candidates.removeAll(oldCandidates);
                    candidates.addAll(newCandidates);
                }
            } else if (frequency == Frequency.MONTHLY) {
                if (!isByMonthDay) {
                    ArrayList<Date> newCandidates = new ArrayList<Date>();
                    List<Date> oldCandidates = candidates;
                    Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                    for (Date date : candidates) {
                        for (WeekDay aDay : this.dayList.keySet()) {
                            cal.setTime(date);
                            cal.set(5, 1);
                            ArrayList<Date> datesInMonth = new ArrayList<Date>();
                            int setMonth = cal.get(2);
                            while (cal.get(5) <= cal.getMaximum(5) && cal.get(2) == setMonth) {
                                if (cal.get(7) == aDay.getCalendarDay()) {
                                    datesInMonth.add(cal.getTime());
                                }
                                cal.add(6, 1);
                            }
                            cal.setTime(date);
                            if ((Integer)this.dayList.get((Object)aDay) > 0 && (Integer)this.dayList.get((Object)aDay) <= datesInMonth.size()) {
                                newCandidates.add((Date)datesInMonth.get((Integer)this.dayList.get((Object)aDay) - 1));
                                continue;
                            }
                            if ((Integer)this.dayList.get((Object)aDay) < 0 && (Integer)this.dayList.get((Object)aDay) >= -datesInMonth.size()) {
                                newCandidates.add((Date)datesInMonth.get(datesInMonth.size() + (Integer)this.dayList.get((Object)aDay)));
                                continue;
                            }
                            if ((Integer)this.dayList.get((Object)aDay) != 0) continue;
                            newCandidates.addAll(datesInMonth);
                        }
                    }
                    candidates.removeAll(oldCandidates);
                    candidates.addAll(newCandidates);
                } else {
                    ArrayList<Date> pruneCandidates = new ArrayList<Date>();
                    Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                    for (Date aDate : candidates) {
                        cal.setTime(aDate);
                        if (this.dayList.keySet().contains((Object)WeekDay.getWeekDay(cal.get(7) - 1))) continue;
                        pruneCandidates.add(aDate);
                    }
                    candidates.removeAll(pruneCandidates);
                }
            } else if (frequency == Frequency.WEEKLY) {
                ArrayList<Date> newCandidates = new ArrayList<Date>();
                List<Date> oldCandidates = candidates;
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date date : candidates) {
                    for (WeekDay aDay : this.dayList.keySet()) {
                        cal.setTime(date);
                        cal.setFirstDayOfWeek(weekStart.getCalendarDay());
                        cal.set(7, aDay.getCalendarDay());
                        newCandidates.add(cal.getTime());
                    }
                }
                candidates.removeAll(oldCandidates);
                candidates.addAll(newCandidates);
            } else {
                ArrayList<Date> pruneCandidates = new ArrayList<Date>();
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date aDate : candidates) {
                    cal.setTime(aDate);
                    if (this.dayList.keySet().contains((Object)WeekDay.getWeekDay(cal.get(7) - 1))) continue;
                    pruneCandidates.add(aDate);
                }
                candidates.removeAll(pruneCandidates);
            }
            return candidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(1, 31, true, true);
        }

        @Override
        public int order() {
            return 8;
        }
    }

    protected abstract class DayListRecurrenceExpressionPart
    extends RecurrenceExpressionPart {
        protected HashMap<WeekDay, Integer> dayList;

        public DayListRecurrenceExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public void parse() throws ParseException {
            this.dayList = new HashMap();
            StringTokenizer valueTokenizer = new StringTokenizer(this.getPart(), ",");
            while (valueTokenizer.hasMoreTokens()) {
                String v = valueTokenizer.nextToken();
                try {
                    try {
                        WeekDay day = WeekDay.getWeekDay(v);
                        this.dayList.put(day, 0);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        String dayname = StringUtils.right((String)v, (int)2);
                        String occurrence = StringUtils.left((String)v, (int)(v.length() - 2));
                        if (occurrence.length() == 0) {
                            this.dayList.put(WeekDay.getWeekDay(dayname), 0);
                            continue;
                        }
                        this.dayList.put(WeekDay.getWeekDay(dayname), Integer.parseInt(occurrence));
                    }
                }
                catch (Exception exception) {
                    throw new ParseException("Invalid day/occurence value : " + v, 0);
                }
            }
        }

        public boolean isNumeric() {
            if (this.dayList != null) {
                for (Integer number : this.dayList.values()) {
                    if (number == 0) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum Frequency {
        SECONDLY("SECONDLY", 13),
        MINUTELY("MINUTELY", 12),
        HOURLY("HOURLY", 11),
        DAILY("DAILY", 6),
        WEEKLY("WEEKLY", 3),
        MONTHLY("MONTHLY", 2),
        YEARLY("YEARLY", 1);

        private final String identifier;
        private final int calendarField;

        private Frequency(String id, int field) {
            this.identifier = id;
            this.calendarField = field;
        }

        public static Frequency getFrequency(String id) {
            Frequency[] frequencyArray = Frequency.values();
            int n = frequencyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Frequency aFrequency = frequencyArray[n2];
                if (aFrequency.toString().equals(id)) {
                    return aFrequency;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid frequency value " + id);
        }

        public int getCalendarField() {
            return this.calendarField;
        }

        public String toString() {
            return this.identifier;
        }
    }

    public class FrequencyExpressionPart
    extends RecurrenceExpressionPart {
        protected static final int SEEDS = 100;
        protected Frequency frequency;

        public FrequencyExpressionPart(String s) throws ParseException {
            super(s);
        }

        public Frequency getFrequency() {
            return this.frequency;
        }

        @Override
        public void parse() throws ParseException {
            this.frequency = Frequency.getFrequency(this.getPart());
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            IntervalExpressionPart intervalPart = RecurrenceExpression.this.getExpressionPart(IntervalExpressionPart.class);
            Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
            cal.setLenient(false);
            cal.setTime(RecurrenceExpression.this.getStartDate());
            ArrayList<Date> ret = new ArrayList<Date>();
            ArrayList<Date> newCandidates = new ArrayList<Date>();
            newCandidates.add(cal.getTime());
            int interval = intervalPart != null ? intervalPart.getInterval() : 1;
            int i = 1;
            while (i < 100) {
                cal.add(this.frequency.getCalendarField(), interval);
                newCandidates.add(cal.getTime());
                ++i;
            }
            ret.addAll(newCandidates);
            return ret;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return null;
        }

        @Override
        public int order() {
            return 3;
        }
    }

    public class HourExpressionPart
    extends IntegerListRecurrenceExpressionPart {
        protected static final int MIN_HOUR = 0;
        protected static final int MAX_HOUR = 23;

        public HourExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            FrequencyExpressionPart freqpart = RecurrenceExpression.this.getExpressionPart(FrequencyExpressionPart.class);
            Frequency frequency = freqpart.getFrequency();
            if (frequency == Frequency.YEARLY || frequency == Frequency.MONTHLY || frequency == Frequency.WEEKLY || frequency == Frequency.DAILY) {
                ArrayList<Date> newCandidates = new ArrayList<Date>();
                List<Date> oldCandidates = candidates;
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date date : candidates) {
                    cal.setTime(date);
                    for (Integer element : this.getValueSet()) {
                        cal.set(11, element);
                        newCandidates.add(cal.getTime());
                    }
                }
                candidates.removeAll(oldCandidates);
                candidates.addAll(newCandidates);
            } else {
                ArrayList<Date> pruneCandidates = new ArrayList<Date>();
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date aDate : candidates) {
                    cal.setTime(aDate);
                    if (this.getValueSet().contains(cal.get(11))) continue;
                    pruneCandidates.add(aDate);
                }
                candidates.removeAll(pruneCandidates);
            }
            return candidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(0, 23, false, false);
        }

        @Override
        public int order() {
            return 9;
        }
    }

    protected abstract class IntegerListRecurrenceExpressionPart
    extends RecurrenceExpressionPart {
        public IntegerListRecurrenceExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public void parse() throws ParseException {
            this.setValueSet(this.initializeValueSet());
            StringTokenizer valueTokenizer = new StringTokenizer(this.getPart(), ",");
            while (valueTokenizer.hasMoreTokens()) {
                String v = valueTokenizer.nextToken();
                try {
                    try {
                        this.getValueSet().add(Integer.parseInt(v));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Invalid integer value : " + v, 0);
                    }
                    this.getValueSet().add(Integer.parseInt(v));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Invalid integer value : " + v, 0);
                }
            }
        }
    }

    public class IntervalExpressionPart
    extends RecurrenceExpressionPart {
        int interval;

        public IntervalExpressionPart(String s) throws ParseException {
            super(s);
        }

        public int getInterval() {
            return this.interval;
        }

        @Override
        public void parse() throws ParseException {
            try {
                this.interval = Integer.parseInt(this.getPart());
                if (this.interval <= 0) {
                    throw new IllegalArgumentException("Inteval must be a postive integer");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Invalid integer value for INTERVAL : " + this.getPart(), 0);
            }
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            return candidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return null;
        }

        @Override
        public int order() {
            return 1;
        }
    }

    public class MinuteExpressionPart
    extends IntegerListRecurrenceExpressionPart {
        protected static final int MIN_MINUTE = 0;
        protected static final int MAX_MINUTE = 59;

        public MinuteExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            FrequencyExpressionPart freqpart = RecurrenceExpression.this.getExpressionPart(FrequencyExpressionPart.class);
            Frequency frequency = freqpart.getFrequency();
            if (frequency == Frequency.YEARLY || frequency == Frequency.MONTHLY || frequency == Frequency.WEEKLY || frequency == Frequency.DAILY || frequency == Frequency.HOURLY) {
                ArrayList<Date> newCandidates = new ArrayList<Date>();
                List<Date> oldCandidates = candidates;
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date date : candidates) {
                    cal.setTime(date);
                    for (Integer element : this.getValueSet()) {
                        cal.set(12, element);
                        newCandidates.add(cal.getTime());
                    }
                }
                candidates.removeAll(oldCandidates);
                candidates.addAll(newCandidates);
            } else {
                ArrayList<Date> pruneCandidates = new ArrayList<Date>();
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date aDate : candidates) {
                    cal.setTime(aDate);
                    if (this.getValueSet().contains(cal.get(12))) continue;
                    pruneCandidates.add(aDate);
                }
                candidates.removeAll(pruneCandidates);
            }
            return candidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(0, 59, false, true);
        }

        @Override
        public int order() {
            return 10;
        }
    }

    public class MonthDayExpressionPart
    extends IntegerListRecurrenceExpressionPart {
        protected static final int MIN_MONTHDAY = 1;
        protected static final int MAX_MONTHDAY = 31;

        public MonthDayExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            FrequencyExpressionPart freqpart = RecurrenceExpression.this.getExpressionPart(FrequencyExpressionPart.class);
            Frequency frequency = freqpart.getFrequency();
            if (frequency == Frequency.YEARLY || frequency == Frequency.MONTHLY) {
                ArrayList<Date> newCandidates = new ArrayList<Date>();
                List<Date> oldCandidates = candidates;
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date date : candidates) {
                    for (Integer element : this.getValueSet()) {
                        cal.setTime(date);
                        if (element > 0 && element <= cal.getMaximum(5)) {
                            cal.set(5, element);
                            newCandidates.add(cal.getTime());
                            continue;
                        }
                        if (cal.getMaximum(5) + element + 1 <= 0) continue;
                        cal.set(5, cal.getMaximum(5) + element + 1);
                        newCandidates.add(cal.getTime());
                    }
                }
                candidates.removeAll(oldCandidates);
                candidates.addAll(newCandidates);
            } else if (frequency == Frequency.SECONDLY || frequency == Frequency.MINUTELY || frequency == Frequency.HOURLY || frequency == Frequency.DAILY) {
                ArrayList<Date> pruneCandidates = new ArrayList<Date>();
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date aDate : candidates) {
                    cal.setTime(aDate);
                    if (this.getValueSet().contains(cal.get(5))) continue;
                    pruneCandidates.add(aDate);
                }
                candidates.removeAll(pruneCandidates);
            }
            return candidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(1, 31, true, true);
        }

        @Override
        public int order() {
            return 7;
        }
    }

    public class MonthExpressionPart
    extends IntegerListRecurrenceExpressionPart {
        protected static final int MIN_MONTH = 1;
        protected static final int MAX_MONTH = 12;

        public MonthExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            FrequencyExpressionPart freqpart = RecurrenceExpression.this.getExpressionPart(FrequencyExpressionPart.class);
            Frequency frequency = freqpart.getFrequency();
            if (frequency == Frequency.YEARLY) {
                ArrayList<Date> newCandidates = new ArrayList<Date>();
                List<Date> oldCandidates = candidates;
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date date : candidates) {
                    cal.setTime(date);
                    for (Integer element : this.getValueSet()) {
                        cal.roll(2, element - 1 - cal.get(2));
                        newCandidates.add(cal.getTime());
                    }
                }
                candidates.removeAll(oldCandidates);
                candidates.addAll(newCandidates);
            } else {
                ArrayList<Date> pruneCandidates = new ArrayList<Date>();
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date aDate : candidates) {
                    cal.setTime(aDate);
                    if (this.getValueSet().contains(cal.get(2) + (this.getValueSet().is1indexed ? 1 : 0))) continue;
                    pruneCandidates.add(aDate);
                }
                candidates.removeAll(pruneCandidates);
            }
            return candidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(1, 12, false, true);
        }

        @Override
        public int order() {
            return 4;
        }
    }

    public class PositionExpressionPart
    extends IntegerListRecurrenceExpressionPart {
        private static final int MIN_SETPOS = 1;
        private static final int MAX_SETPOS = 366;

        public PositionExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            ArrayList<Date> selectCandidates = new ArrayList<Date>();
            FrequencyExpressionPart freqpart = RecurrenceExpression.this.getExpressionPart(FrequencyExpressionPart.class);
            Frequency frequency = freqpart.getFrequency();
            Collections.sort(candidates);
            ArrayList segments = new ArrayList();
            ArrayList<Date> segment = null;
            Calendar segmentStart = null;
            boolean segmentEnded = false;
            for (Date date : candidates) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                if (segmentStart == null || segmentEnded) {
                    if (segmentEnded) {
                        segmentEnded = false;
                        segments.add(segment);
                        segment = new ArrayList();
                        segment.add(segmentStart.getTime());
                        continue;
                    }
                    segmentStart = cal;
                    segment = new ArrayList<Date>();
                    segment.add(date);
                    continue;
                }
                switch (frequency) {
                    case DAILY: {
                        if (segmentStart.get(7) == cal.get(7)) {
                            segment.add(date);
                            break;
                        }
                        segmentEnded = true;
                        segmentStart = cal;
                        break;
                    }
                    case HOURLY: {
                        if (segmentStart.get(10) == cal.get(10)) {
                            segment.add(date);
                            break;
                        }
                        segmentEnded = true;
                        segmentStart = cal;
                        break;
                    }
                    case MINUTELY: {
                        if (segmentStart.get(12) == cal.get(12)) {
                            segment.add(date);
                            break;
                        }
                        segmentEnded = true;
                        segmentStart = cal;
                        break;
                    }
                    case MONTHLY: {
                        if (segmentStart.get(2) == cal.get(2)) {
                            segment.add(date);
                            break;
                        }
                        segmentEnded = true;
                        segmentStart = cal;
                        break;
                    }
                    case SECONDLY: {
                        if (segmentStart.get(13) == cal.get(13)) {
                            segment.add(date);
                            break;
                        }
                        segmentEnded = true;
                        segmentStart = cal;
                        break;
                    }
                    case WEEKLY: {
                        if (segmentStart.get(3) == cal.get(3)) {
                            segment.add(date);
                            break;
                        }
                        segmentEnded = true;
                        segmentStart = cal;
                        break;
                    }
                    case YEARLY: {
                        if (segmentStart.get(1) == cal.get(1)) {
                            segment.add(date);
                            break;
                        }
                        segmentEnded = true;
                        segmentStart = cal;
                        break;
                    }
                }
            }
            segments.add(segment);
            for (List list : segments) {
                for (Integer position : this.getValueSet()) {
                    if (position > 0 && position <= list.size()) {
                        selectCandidates.add((Date)list.get(position - 1));
                        continue;
                    }
                    if (position >= 0 || position < -list.size()) continue;
                    selectCandidates.add((Date)list.get(list.size() + position));
                }
            }
            return selectCandidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(1, 366, true, true);
        }

        @Override
        public int order() {
            return 12;
        }
    }

    protected abstract class RecurrenceExpressionPart
    extends AbstractExpressionPart {
        public RecurrenceExpressionPart(String s) throws ParseException {
            super(s);
        }
    }

    public class SecondExpressionPart
    extends IntegerListRecurrenceExpressionPart {
        protected static final int MIN_SECOND = 0;
        protected static final int MAX_SECOND = 59;

        public SecondExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            FrequencyExpressionPart freqpart = RecurrenceExpression.this.getExpressionPart(FrequencyExpressionPart.class);
            Frequency frequency = freqpart.getFrequency();
            if (frequency == Frequency.YEARLY || frequency == Frequency.MONTHLY || frequency == Frequency.WEEKLY || frequency == Frequency.DAILY || frequency == Frequency.HOURLY || frequency == Frequency.MINUTELY) {
                ArrayList<Date> newCandidates = new ArrayList<Date>();
                List<Date> oldCandidates = candidates;
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date date : candidates) {
                    cal.setTime(date);
                    for (Integer element : this.getValueSet()) {
                        cal.set(13, element);
                        newCandidates.add(cal.getTime());
                    }
                }
                candidates.removeAll(oldCandidates);
                candidates.addAll(newCandidates);
            } else {
                ArrayList<Date> pruneCandidates = new ArrayList<Date>();
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date aDate : candidates) {
                    cal.setTime(aDate);
                    if (this.getValueSet().contains(cal.get(13))) continue;
                    pruneCandidates.add(aDate);
                }
                candidates.removeAll(pruneCandidates);
            }
            return candidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(0, 59, false, false);
        }

        @Override
        public int order() {
            return 11;
        }
    }

    public class UntilExpressionPart
    extends RecurrenceExpressionPart {
        private static final String LOCALTIME_FORMAT = "yyyyMMdd'T'HHmmss";
        private static final String UTCTIME_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
        private static final String DEFAULT_FORMAT = "yyyyMMdd";
        Date until;

        public UntilExpressionPart(String s) throws ParseException {
            super(s);
        }

        public Date getUntil() {
            return this.until;
        }

        @Override
        public void parse() throws ParseException {
            SimpleDateFormat format = null;
            if (this.getPart().contains("T")) {
                if (this.getPart().contains("Z")) {
                    format = new SimpleDateFormat(UTCTIME_FORMAT);
                    format.setLenient(false);
                    format.setTimeZone(TimeZone.getTimeZone("GMT"));
                } else {
                    format = new SimpleDateFormat(LOCALTIME_FORMAT);
                    format.setLenient(false);
                    format.setTimeZone(RecurrenceExpression.this.getTimeZone());
                }
            } else {
                format = new SimpleDateFormat(DEFAULT_FORMAT);
                format.setLenient(false);
                format.setTimeZone(RecurrenceExpression.this.getTimeZone());
            }
            try {
                this.until = format.parse(this.getPart());
            }
            catch (Exception exception) {
                throw new ParseException("Invalid date format for UNTIL : " + this.getPart(), 0);
            }
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            ArrayList<Date> filtered = new ArrayList<Date>();
            Collections.sort(candidates);
            for (Date aDate : candidates) {
                if (!aDate.before(this.until) && !aDate.equals(this.until)) continue;
                filtered.add(aDate);
            }
            return filtered;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return null;
        }

        @Override
        public int order() {
            return 13;
        }
    }

    public static enum WeekDay {
        SUNDAY("SU", 1),
        MONDAY("MO", 2),
        TUESDAY("TU", 3),
        WEDNESDAY("WE", 4),
        THURSDAY("TH", 5),
        FRIDAY("FR", 6),
        SATURDAY("SA", 7);

        private final String identifier;
        private final int calendarDay;

        public static WeekDay getWeekDay(int calendar) {
            return WeekDay.values()[calendar];
        }

        public static WeekDay getWeekDay(String id) {
            WeekDay[] weekDayArray = WeekDay.values();
            int n = weekDayArray.length;
            int n2 = 0;
            while (n2 < n) {
                WeekDay aDay = weekDayArray[n2];
                if (aDay.toString().equals(id)) {
                    return aDay;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid calendar value " + id);
        }

        private WeekDay(String code, int day) {
            this.identifier = code;
            this.calendarDay = day;
        }

        public int getCalendarDay() {
            return this.calendarDay;
        }

        public String toString() {
            return this.identifier;
        }
    }

    public class WeekNumberExpressionPart
    extends IntegerListRecurrenceExpressionPart {
        private static final int MIN_WEEKNO = 1;
        private static final int MAX_WEEKNO = 53;

        public WeekNumberExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            WeekDay weekStart;
            FrequencyExpressionPart freqpart = RecurrenceExpression.this.getExpressionPart(FrequencyExpressionPart.class);
            Frequency frequency = freqpart.getFrequency();
            WeekStartExpressionPart weekStartPart = RecurrenceExpression.this.getExpressionPart(WeekStartExpressionPart.class);
            WeekDay weekDay = weekStart = weekStartPart != null ? weekStartPart.getWeekStart() : WeekDay.MONDAY;
            if (frequency == Frequency.YEARLY) {
                ArrayList<Date> newCandidates = new ArrayList<Date>();
                List<Date> oldCandidates = candidates;
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                cal.setFirstDayOfWeek(weekStart.getCalendarDay());
                for (Date date : candidates) {
                    for (Integer element : this.getValueSet()) {
                        cal.setTime(date);
                        if (element > 0 && element <= cal.getMaximum(3)) {
                            cal.set(3, element);
                            newCandidates.add(cal.getTime());
                            continue;
                        }
                        if (cal.getMaximum(53) + element + 1 <= 0) continue;
                        cal.set(3, cal.getMaximum(53) + element + 1);
                        newCandidates.add(cal.getTime());
                    }
                }
                candidates.removeAll(oldCandidates);
                candidates.addAll(newCandidates);
            } else {
                RecurrenceExpression.this.logger.warn("BYWEEKNO can only be used together with YEARLY");
            }
            return candidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(1, 53, true, true);
        }

        @Override
        public int order() {
            return 5;
        }
    }

    public class WeekStartExpressionPart
    extends RecurrenceExpressionPart {
        WeekDay weekStart;

        public WeekStartExpressionPart(String s) throws ParseException {
            super(s);
        }

        public WeekDay getWeekStart() {
            return this.weekStart;
        }

        @Override
        public void parse() throws ParseException {
            try {
                this.weekStart = WeekDay.getWeekDay(this.getPart());
            }
            catch (Exception exception) {
                throw new ParseException("Invalid value for WKST: " + this.getPart(), 0);
            }
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            return candidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return null;
        }

        @Override
        public int order() {
            return 2;
        }
    }

    public class YearDayExpressionPart
    extends IntegerListRecurrenceExpressionPart {
        private static final int MIN_YEARDAY = 1;
        private static final int MAX_YEARDAY = 366;

        public YearDayExpressionPart(String s) throws ParseException {
            super(s);
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            FrequencyExpressionPart freqpart = RecurrenceExpression.this.getExpressionPart(FrequencyExpressionPart.class);
            Frequency frequency = freqpart.getFrequency();
            if (frequency == Frequency.YEARLY) {
                ArrayList<Date> newCandidates = new ArrayList<Date>();
                List<Date> oldCandidates = candidates;
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date date : candidates) {
                    for (Integer element : this.getValueSet()) {
                        cal.setTime(date);
                        if (element > 0 && element <= cal.getMaximum(6)) {
                            cal.set(6, element);
                            newCandidates.add(cal.getTime());
                            continue;
                        }
                        if (cal.getMaximum(6) + element + 1 <= 0) continue;
                        cal.set(6, cal.getMaximum(6) + element + 1);
                        newCandidates.add(cal.getTime());
                    }
                }
                candidates.removeAll(oldCandidates);
                candidates.addAll(newCandidates);
            } else if (frequency == Frequency.SECONDLY || frequency == Frequency.MINUTELY || frequency == Frequency.HOURLY) {
                ArrayList<Date> pruneCandidates = new ArrayList<Date>();
                Calendar cal = Calendar.getInstance(RecurrenceExpression.this.getTimeZone());
                for (Date aDate : candidates) {
                    cal.setTime(aDate);
                    if (this.getValueSet().contains(cal.get(6))) continue;
                    pruneCandidates.add(aDate);
                }
                candidates.removeAll(pruneCandidates);
            }
            return candidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return new AbstractExpressionPart.BoundedIntegerSet(1, 366, true, true);
        }

        @Override
        public int order() {
            return 6;
        }
    }
}

