/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.console.internal.extension;

import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemNotUniqueException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConsoleCommandExtension.class})
public class SendConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private ItemRegistry itemRegistry;
    private EventPublisher eventPublisher;

    public SendConsoleCommandExtension() {
        super("send", "Send a command to an item.");
    }

    @Override
    public List<String> getUsages() {
        return Collections.singletonList(this.buildCommandUsage("<item> <command>", "sends a command for an item"));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(String[] args, Console console) {
        block12: {
            if (args.length > 0) {
                itemName = args[0];
                try {
                    item = this.itemRegistry.getItemByPattern(itemName);
                    if (args.length > 1) {
                        commandName = args[1];
                        command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)commandName);
                        if (command != null) {
                            this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)itemName, (Command)command));
                            console.println("Command has been sent successfully.");
                        } else {
                            console.println("Error: Command '" + commandName + "' is not valid for item '" + itemName + "'");
                            console.println("Valid command types are:");
                            for (Class acceptedType : item.getAcceptedCommandTypes()) {
                                console.print("  " + acceptedType.getSimpleName());
                                if (acceptedType.isEnum()) {
                                    console.print(": ");
                                    var12_15 = acceptedType.getEnumConstants();
                                    var11_14 = var12_15.length;
                                    var10_13 = 0;
                                    while (var10_13 < var11_14) {
                                        e = var12_15[var10_13];
                                        console.print(e + " ");
                                        ++var10_13;
                                    }
                                }
                                console.println("");
                            }
                        }
                    } else {
                        this.printUsage(console);
                    }
                    break block12;
                }
                catch (ItemNotFoundException v0) {
                    console.println("Error: Item '" + itemName + "' does not exist.");
                    break block12;
                }
                catch (ItemNotUniqueException e) {
                    console.print("Error: Multiple items match this pattern: ");
                    ** for (item : e.getMatchingItems())
                }
lbl-1000:
                // 1 sources

                {
                    console.print(String.valueOf(item.getName()) + " ");
                    continue;
lbl39:
                    // 1 sources

                    break block12;
                }
            }
            this.printUsage(console);
        }
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }
}

