/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.mqttembeddedbroker.internal;

import io.moquette.interception.InterceptHandler;
import io.moquette.interception.messages.InterceptAcknowledgedMessage;
import io.moquette.interception.messages.InterceptConnectMessage;
import io.moquette.interception.messages.InterceptConnectionLostMessage;
import io.moquette.interception.messages.InterceptDisconnectMessage;
import io.moquette.interception.messages.InterceptPublishMessage;
import io.moquette.interception.messages.InterceptSubscribeMessage;
import io.moquette.interception.messages.InterceptUnsubscribeMessage;
import io.moquette.server.Server;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class MqttEmbeddedBrokerMetrics
implements InterceptHandler {
    private final BrokerMetricsListener listener;
    private @Nullable Server server;

    public MqttEmbeddedBrokerMetrics(BrokerMetricsListener listener) {
        this.listener = listener;
    }

    public void resetServer() {
        if (this.server != null) {
            this.server.removeInterceptHandler((InterceptHandler)this);
        }
        this.server = null;
    }

    public void setServer(Server server) {
        if (this.server != null) {
            this.server.removeInterceptHandler((InterceptHandler)this);
        }
        this.server = server;
        server.addInterceptHandler((InterceptHandler)this);
    }

    public void onUnsubscribe(@Nullable InterceptUnsubscribeMessage msg) {
    }

    public void onSubscribe(@Nullable InterceptSubscribeMessage msg) {
    }

    public void onPublish(@Nullable InterceptPublishMessage msg) {
    }

    public void onMessageAcknowledged(@Nullable InterceptAcknowledgedMessage msg) {
    }

    public void onDisconnect(@Nullable InterceptDisconnectMessage msg) {
        Server server = this.server;
        if (server != null) {
            this.listener.connectedClientIDs(server.getConnectionsManager().getConnectedClientIds());
        }
    }

    public void onConnectionLost(@Nullable InterceptConnectionLostMessage msg) {
        Server server = this.server;
        if (server != null) {
            this.listener.connectedClientIDs(server.getConnectionsManager().getConnectedClientIds());
        }
    }

    public void onConnect(@Nullable InterceptConnectMessage msg) {
        Server server = this.server;
        if (server != null) {
            this.listener.connectedClientIDs(server.getConnectionsManager().getConnectedClientIds());
        }
    }

    public Class<?>[] getInterceptedMessageTypes() {
        return new Class[]{InterceptConnectMessage.class, InterceptConnectionLostMessage.class, InterceptDisconnectMessage.class};
    }

    public String getID() {
        return "collectmetrics";
    }

    public static interface BrokerMetricsListener {
        public void connectedClientIDs(Collection<String> var1);
    }
}

