/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.net.http.internal;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.eclipse.smarthome.io.net.http.TlsCertificateProvider;
import org.eclipse.smarthome.io.net.http.TlsTrustManagerProvider;
import org.eclipse.smarthome.io.net.http.internal.TlsCertificateTrustManagerAdapter;
import org.eclipse.smarthome.io.net.http.internal.TrustManagerUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ExtensibleTrustManager.class}, immediate=true)
public class ExtensibleTrustManager
extends X509ExtendedTrustManager {
    private final Logger logger = LoggerFactory.getLogger(ExtensibleTrustManager.class);
    private static final Queue<X509ExtendedTrustManager> EMPTY_QUEUE = new ConcurrentLinkedQueue<X509ExtendedTrustManager>();
    private final X509ExtendedTrustManager defaultTrustManager = TrustManagerUtil.keyStoreToTrustManager(null);
    private final Map<String, Queue<X509ExtendedTrustManager>> linkedTrustManager = new ConcurrentHashMap<String, Queue<X509ExtendedTrustManager>>();
    private final Map<TlsCertificateProvider, X509ExtendedTrustManager> mappingFromTlsCertificateProvider = new ConcurrentHashMap<TlsCertificateProvider, X509ExtendedTrustManager>();

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkClientTrusted(chain, authType, (Socket)null);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkServerTrusted(chain, authType, (Socket)null);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        X509ExtendedTrustManager linkedTrustManager = this.getLinkedTrustMananger(chain);
        if (linkedTrustManager == null) {
            this.logger.trace("No specific trust manager found, falling back to default");
            this.defaultTrustManager.checkClientTrusted(chain, authType, socket);
        } else {
            linkedTrustManager.checkClientTrusted(chain, authType, socket);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        X509ExtendedTrustManager linkedTrustManager = this.getLinkedTrustMananger(chain);
        if (linkedTrustManager == null) {
            this.logger.trace("No specific trust manager found, falling back to default");
            this.defaultTrustManager.checkClientTrusted(chain, authType, sslEngine);
        } else {
            linkedTrustManager.checkClientTrusted(chain, authType, sslEngine);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        X509ExtendedTrustManager linkedTrustManager = this.getLinkedTrustMananger(chain);
        if (linkedTrustManager == null) {
            this.logger.trace("No specific trust manager found, falling back to default");
            this.defaultTrustManager.checkServerTrusted(chain, authType, socket);
        } else {
            linkedTrustManager.checkServerTrusted(chain, authType, socket);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        X509ExtendedTrustManager linkedTrustManager = this.getLinkedTrustMananger(chain);
        if (linkedTrustManager == null) {
            this.logger.trace("No specific trust manager found, falling back to default");
            this.defaultTrustManager.checkServerTrusted(chain, authType, sslEngine);
        } else {
            linkedTrustManager.checkServerTrusted(chain, authType, sslEngine);
        }
    }

    private X509ExtendedTrustManager getLinkedTrustMananger(X509Certificate[] chain) {
        try {
            String commonName = this.getCommonName(chain[0]);
            X509ExtendedTrustManager trustManager = this.linkedTrustManager.getOrDefault(commonName, EMPTY_QUEUE).peek();
            if (trustManager != null) {
                this.logger.trace("Found trustManager by common name: {}", (Object)commonName);
                return trustManager;
            }
            this.logger.trace("Searching trustManager by Subject Alternative Names: {}", chain[0].getSubjectAlternativeNames());
            return chain[0].getSubjectAlternativeNames().stream().map(e -> e.get(1)).map(Object::toString).map(this.linkedTrustManager::get).filter(Objects::nonNull).map(Queue::peek).filter(Objects::nonNull).findFirst().orElse(null);
        }
        catch (CertificateParsingException e2) {
            throw new IllegalStateException("Problem while parsing certificate", e2);
        }
    }

    private String getCommonName(X509Certificate x509Certificate) {
        String dn = x509Certificate.getSubjectX500Principal().getName("RFC2253");
        String[] stringArray = dn.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            if (group.contains("CN=")) {
                return group.trim().replace("CN=", "");
            }
            ++n2;
        }
        throw new IllegalStateException("No Common Name found");
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addTlsCertificateProvider(TlsCertificateProvider tlsCertificateProvider) {
        X509ExtendedTrustManager trustManager = new TlsCertificateTrustManagerAdapter(tlsCertificateProvider).getTrustManager();
        this.mappingFromTlsCertificateProvider.put(tlsCertificateProvider, trustManager);
        this.addLinkedTrustManager(tlsCertificateProvider.getHostName(), trustManager);
    }

    protected void removeTlsCertificateProvider(TlsCertificateProvider tlsCertificateProvider) {
        this.removeLinkedTrustManager(tlsCertificateProvider.getHostName(), this.mappingFromTlsCertificateProvider.remove(tlsCertificateProvider));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addTlsTrustManagerProvider(TlsTrustManagerProvider tlsTrustManagerProvider) {
        this.addLinkedTrustManager(tlsTrustManagerProvider.getHostName(), tlsTrustManagerProvider.getTrustManager());
    }

    protected void removeTlsTrustManagerProvider(TlsTrustManagerProvider tlsTrustManagerProvider) {
        this.removeLinkedTrustManager(tlsTrustManagerProvider.getHostName(), tlsTrustManagerProvider.getTrustManager());
    }

    private void addLinkedTrustManager(String hostName, X509ExtendedTrustManager trustManager) {
        this.linkedTrustManager.computeIfAbsent(hostName, h -> new ConcurrentLinkedQueue()).add(trustManager);
    }

    private void removeLinkedTrustManager(String hostName, X509ExtendedTrustManager trustManager) {
        this.linkedTrustManager.computeIfAbsent(hostName, h -> new ConcurrentLinkedQueue()).remove(trustManager);
    }
}

