/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.binding;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.ConfigUtil;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.binding.BindingInfo;
import org.eclipse.smarthome.core.binding.BindingInfoRegistry;
import org.eclipse.smarthome.core.binding.dto.BindingInfoDTO;
import org.eclipse.smarthome.io.rest.LocaleService;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.Stream2JSONInputStream;
import org.eclipse.smarthome.io.rest.core.config.ConfigurationService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="bindings")
@RolesAllowed(value={"administrator"})
@Api(value="bindings")
@Component
public class BindingResource
implements RESTResource {
    public static final String PATH_BINDINGS = "bindings";
    private final Logger logger = LoggerFactory.getLogger(BindingResource.class);
    private ConfigurationService configurationService;
    private ConfigDescriptionRegistry configDescRegistry;
    private BindingInfoRegistry bindingInfoRegistry;
    private LocaleService localeService;
    @Context
    UriInfo uriInfo;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setBindingInfoRegistry(BindingInfoRegistry bindingInfoRegistry) {
        this.bindingInfoRegistry = bindingInfoRegistry;
    }

    protected void unsetBindingInfoRegistry(BindingInfoRegistry bindingInfoRegistry) {
        this.bindingInfoRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setLocaleService(LocaleService localeService) {
        this.localeService = localeService;
    }

    protected void unsetLocaleService(LocaleService localeService) {
        this.localeService = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all bindings.", response=BindingInfoDTO.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=BindingInfoDTO.class, responseContainer="Set")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language) {
        Locale locale = this.localeService.getLocale(language);
        Set bindingInfos = this.bindingInfoRegistry.getBindingInfos(locale);
        return Response.ok((Object)new Stream2JSONInputStream(bindingInfos.stream().map(b -> this.map((BindingInfo)b, locale)))).build();
    }

    @GET
    @Path(value="/{bindingId}/config")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get binding configuration for given binding ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=404, message="Binding does not exist"), @ApiResponse(code=500, message="Configuration can not be read due to internal error")})
    public Response getConfiguration(@PathParam(value="bindingId") @ApiParam(value="service ID", required=true) String bindingId) {
        try {
            String configId = this.getConfigId(bindingId);
            if (configId == null) {
                this.logger.warn("Cannot get config id for binding id '{}', probably because binding does not exist.", (Object)bindingId);
                return Response.status((int)404).build();
            }
            Configuration configuration = this.configurationService.get(configId);
            return configuration != null ? Response.ok((Object)configuration.getProperties()).build() : Response.ok(Collections.emptyMap()).build();
        }
        catch (IOException ex) {
            this.logger.error("Cannot get configuration for service {}: {}", new Object[]{bindingId, ex.getMessage(), ex});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Path(value="/{bindingId}/config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates a binding configuration for given binding ID and returns the old configuration.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=204, message="No old configuration"), @ApiResponse(code=404, message="Binding does not exist"), @ApiResponse(code=500, message="Configuration can not be updated due to internal error")})
    public Response updateConfiguration(@PathParam(value="bindingId") @ApiParam(value="service ID", required=true) String bindingId, Map<String, Object> configuration) {
        try {
            String configId = this.getConfigId(bindingId);
            if (configId == null) {
                this.logger.warn("Cannot get config id for binding id '{}', probably because binding does not exist.", (Object)bindingId);
                return Response.status((int)404).build();
            }
            Configuration oldConfiguration = this.configurationService.get(configId);
            this.configurationService.update(configId, new Configuration(this.normalizeConfiguration(configuration, bindingId)));
            return oldConfiguration != null ? Response.ok((Object)oldConfiguration.getProperties()).build() : Response.noContent().build();
        }
        catch (IOException ex) {
            this.logger.error("Cannot update configuration for service {}: {}", new Object[]{bindingId, ex.getMessage(), ex});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Map<String, Object> normalizeConfiguration(Map<String, Object> properties, String bindingId) {
        if (properties == null || properties.isEmpty()) {
            return properties;
        }
        BindingInfo bindingInfo = this.bindingInfoRegistry.getBindingInfo(bindingId);
        if (bindingInfo == null || bindingInfo.getConfigDescriptionURI() == null) {
            return properties;
        }
        ConfigDescription configDesc = this.configDescRegistry.getConfigDescription(bindingInfo.getConfigDescriptionURI());
        if (configDesc == null) {
            return properties;
        }
        return ConfigUtil.normalizeTypes(properties, Collections.singletonList(configDesc));
    }

    private String getConfigId(String bindingId) {
        BindingInfo bindingInfo = this.bindingInfoRegistry.getBindingInfo(bindingId);
        if (bindingInfo != null) {
            return bindingInfo.getServiceId();
        }
        return null;
    }

    private BindingInfoDTO map(BindingInfo bindingInfo, Locale locale) {
        URI configDescriptionURI = bindingInfo.getConfigDescriptionURI();
        return new BindingInfoDTO(bindingInfo.getUID(), bindingInfo.getName(), bindingInfo.getAuthor(), bindingInfo.getDescription(), configDescriptionURI != null ? configDescriptionURI.toString() : null);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected void unsetConfigurationService(ConfigurationService configurationService) {
        this.configurationService = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescRegistry = null;
    }

    public boolean isSatisfied() {
        return this.configurationService != null && this.configDescRegistry != null && this.bindingInfoRegistry != null && this.localeService != null;
    }
}

