/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.discovery;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.config.discovery.DiscoveryServiceRegistry;
import org.eclipse.smarthome.config.discovery.ScanListener;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="discovery")
@RolesAllowed(value={"administrator"})
@Api(value="discovery")
@Component(service={RESTResource.class, DiscoveryResource.class})
public class DiscoveryResource
implements RESTResource {
    public static final String PATH_DISCOVERY = "discovery";
    private final Logger logger = LoggerFactory.getLogger(DiscoveryResource.class);
    private DiscoveryServiceRegistry discoveryServiceRegistry;
    @Context
    private UriInfo uriInfo;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setDiscoveryServiceRegistry(DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry = discoveryServiceRegistry;
    }

    protected void unsetDiscoveryServiceRegistry(DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets all bindings that support discovery.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class, responseContainer="Set")})
    public Response getDiscoveryServices() {
        List supportedBindings = this.discoveryServiceRegistry.getSupportedBindings();
        return Response.ok(new LinkedHashSet(supportedBindings)).build();
    }

    @POST
    @Path(value="/bindings/{bindingId}/scan")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Starts asynchronous discovery process for a binding and returns the timeout in seconds of the discovery operation.", response=Integer.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Integer.class)})
    public Response scan(final @PathParam(value="bindingId") @ApiParam(value="bindingId") String bindingId) {
        this.discoveryServiceRegistry.startScan(bindingId, new ScanListener(){

            public void onErrorOccurred(Exception exception) {
                DiscoveryResource.this.logger.error("Error occurred while scanning for binding '{}': {}", new Object[]{bindingId, exception.getMessage(), exception});
            }

            public void onFinished() {
                DiscoveryResource.this.logger.debug("Scan for binding '{}' successfully finished.", (Object)bindingId);
            }
        });
        return Response.ok((Object)this.discoveryServiceRegistry.getMaxScanTimeout(bindingId)).build();
    }

    public boolean isSatisfied() {
        return this.discoveryServiceRegistry != null;
    }
}

