/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.extensions;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.extension.Extension;
import org.eclipse.smarthome.core.extension.ExtensionEvent;
import org.eclipse.smarthome.core.extension.ExtensionEventFactory;
import org.eclipse.smarthome.core.extension.ExtensionService;
import org.eclipse.smarthome.core.extension.ExtensionType;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.LocaleService;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.Stream2JSONInputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="extensions")
@RolesAllowed(value={"administrator"})
@Api(value="extensions")
@Component
public class ExtensionResource
implements RESTResource {
    private static final String THREAD_POOL_NAME = "extensionService";
    public static final String PATH_EXTENSIONS = "extensions";
    private final Logger logger = LoggerFactory.getLogger(ExtensionResource.class);
    private final Set<ExtensionService> extensionServices = new CopyOnWriteArraySet<ExtensionService>();
    private EventPublisher eventPublisher;
    private LocaleService localeService;
    @Context
    UriInfo uriInfo;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addExtensionService(ExtensionService featureService) {
        this.extensionServices.add(featureService);
    }

    protected void removeExtensionService(ExtensionService featureService) {
        this.extensionServices.remove(featureService);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setLocaleService(LocaleService localeService) {
        this.localeService = localeService;
    }

    protected void unsetLocaleService(LocaleService localeService) {
        this.localeService = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all extensions.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class)})
    public Response getExtensions(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language) {
        this.logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        Locale locale = this.localeService.getLocale(language);
        return Response.ok((Object)new Stream2JSONInputStream(this.getAllExtensions(locale))).build();
    }

    @GET
    @Path(value="/types")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all extension types.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class)})
    public Response getTypes(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language) {
        this.logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        Locale locale = this.localeService.getLocale(language);
        Stream extensionTypeStream = this.getAllExtensionTypes(locale).stream().distinct();
        return Response.ok((Object)new Stream2JSONInputStream(extensionTypeStream)).build();
    }

    @GET
    @Path(value="/{extensionId: [a-zA-Z_0-9-]*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get extension with given ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=404, message="Not found")})
    public Response getById(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="extensionId") @ApiParam(value="extension ID", required=true) String extensionId) {
        this.logger.debug("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
        Locale locale = this.localeService.getLocale(language);
        ExtensionService extensionService = this.getExtensionService(extensionId);
        Extension responseObject = extensionService.getExtension(extensionId, locale);
        if (responseObject != null) {
            return Response.ok((Object)responseObject).build();
        }
        return Response.status((int)404).build();
    }

    @POST
    @Path(value="/{extensionId: [a-zA-Z_0-9-:]*}/install")
    @ApiOperation(value="Installs the extension with the given ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response installExtension(@PathParam(value="extensionId") @ApiParam(value="extension ID", required=true) String extensionId) {
        ThreadPoolManager.getPool((String)THREAD_POOL_NAME).submit(() -> {
            try {
                ExtensionService extensionService = this.getExtensionService(extensionId);
                extensionService.install(extensionId);
            }
            catch (Exception e) {
                this.logger.error("Exception while installing extension: {}", (Object)e.getMessage());
                this.postFailureEvent(extensionId, e.getMessage());
            }
        });
        return Response.ok(null, (String)"text/plain").build();
    }

    @POST
    @Path(value="/url/{url}/install")
    @ApiOperation(value="Installs the extension from the given URL.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="The given URL is malformed or not valid.")})
    public Response installExtensionByURL(@PathParam(value="url") @ApiParam(value="extension install URL", required=true) String url) {
        try {
            URI extensionURI = new URI(url);
            String extensionId = this.getExtensionId(extensionURI);
            this.installExtension(extensionId);
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            this.logger.error("Exception while parsing the extension URL '{}': {}", (Object)url, (Object)e.getMessage());
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)"The given URL is malformed or not valid.");
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    @POST
    @Path(value="/{extensionId: [a-zA-Z_0-9-:]*}/uninstall")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response uninstallExtension(@PathParam(value="extensionId") @ApiParam(value="extension ID", required=true) String extensionId) {
        ThreadPoolManager.getPool((String)THREAD_POOL_NAME).submit(() -> {
            try {
                ExtensionService extensionService = this.getExtensionService(extensionId);
                extensionService.uninstall(extensionId);
            }
            catch (Exception e) {
                this.logger.error("Exception while uninstalling extension: {}", (Object)e.getMessage());
                this.postFailureEvent(extensionId, e.getMessage());
            }
        });
        return Response.ok(null, (String)"text/plain").build();
    }

    private void postFailureEvent(String extensionId, String msg) {
        if (this.eventPublisher != null) {
            ExtensionEvent event = ExtensionEventFactory.createExtensionFailureEvent((String)extensionId, (String)msg);
            this.eventPublisher.post((Event)event);
        }
    }

    public boolean isSatisfied() {
        return !this.extensionServices.isEmpty() && this.localeService != null;
    }

    private Stream<Extension> getAllExtensions(Locale locale) {
        return this.extensionServices.stream().map(s -> s.getExtensions(locale)).flatMap(l -> l.stream());
    }

    private Set<ExtensionType> getAllExtensionTypes(Locale locale) {
        final Collator coll = Collator.getInstance(locale);
        coll.setStrength(0);
        TreeSet<ExtensionType> ret = new TreeSet<ExtensionType>(new Comparator<ExtensionType>(){

            @Override
            public int compare(ExtensionType o1, ExtensionType o2) {
                return coll.compare(o1.getLabel(), o2.getLabel());
            }
        });
        for (ExtensionService extensionService : this.extensionServices) {
            ret.addAll(extensionService.getTypes(locale));
        }
        return ret;
    }

    private ExtensionService getExtensionService(String extensionId) {
        for (ExtensionService extensionService : this.extensionServices) {
            for (Extension extension : extensionService.getExtensions(Locale.getDefault())) {
                if (!extensionId.equals(extension.getId())) continue;
                return extensionService;
            }
        }
        throw new IllegalArgumentException("No extension service registered for " + extensionId);
    }

    private String getExtensionId(URI extensionURI) {
        for (ExtensionService extensionService : this.extensionServices) {
            String extensionId = extensionService.getExtensionId(extensionURI);
            if (!StringUtils.isNotBlank((String)extensionId)) continue;
            return extensionId;
        }
        throw new IllegalArgumentException("No extension service registered for URI " + extensionURI);
    }
}

