/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.profile;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.items.ItemUtil;
import org.eclipse.smarthome.core.thing.profiles.ProfileType;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeRegistry;
import org.eclipse.smarthome.core.thing.profiles.StateProfileType;
import org.eclipse.smarthome.core.thing.profiles.TriggerProfileType;
import org.eclipse.smarthome.core.thing.profiles.dto.ProfileTypeDTO;
import org.eclipse.smarthome.core.thing.profiles.dto.ProfileTypeDTOMapper;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.io.rest.LocaleService;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.Stream2JSONInputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="profile-types")
@RolesAllowed(value={"administrator"})
@Api(value="profile-types")
@Component
public class ProfileTypeResource
implements RESTResource {
    public static final String PATH_PROFILE_TYPES = "profile-types";
    private final Logger logger = LoggerFactory.getLogger(ProfileTypeResource.class);
    private ProfileTypeRegistry profileTypeRegistry;
    private ChannelTypeRegistry channelTypeRegistry;
    private LocaleService localeService;

    @GET
    @RolesAllowed(value={"user"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets all available profile types.", response=ProfileTypeDTO.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ProfileTypeDTO.class, responseContainer="Set")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language, @QueryParam(value="channelTypeUID") @ApiParam(value="channel type filter", required=false) @Nullable String channelTypeUID, @QueryParam(value="itemType") @ApiParam(value="item type filter", required=false) @Nullable String itemType) {
        Locale locale = this.localeService.getLocale(language);
        return Response.ok((Object)new Stream2JSONInputStream(this.getProfileTypes(locale, channelTypeUID, itemType))).build();
    }

    protected Stream<ProfileTypeDTO> getProfileTypes(Locale locale, String channelTypeUID, String itemType) {
        return this.profileTypeRegistry.getProfileTypes(locale).stream().filter(this.matchesChannelUID(channelTypeUID, locale)).filter(this.matchesItemType(itemType)).map(t -> this.convertToProfileTypeDTO((ProfileType)t, locale));
    }

    private Predicate<ProfileType> matchesChannelUID(String channelTypeUID, Locale locale) {
        if (channelTypeUID == null) {
            return t -> true;
        }
        ChannelType channelType = this.channelTypeRegistry.getChannelType(new ChannelTypeUID(channelTypeUID), locale);
        if (channelType == null) {
            return t -> false;
        }
        switch (channelType.getKind()) {
            case STATE: {
                return t -> this.stateProfileMatchesProfileType((ProfileType)t, channelType);
            }
            case TRIGGER: {
                return t -> this.triggerProfileMatchesProfileType((ProfileType)t, channelType);
            }
        }
        return t -> false;
    }

    private Predicate<ProfileType> matchesItemType(String itemType) {
        if (itemType == null) {
            return t -> true;
        }
        return t -> this.profileTypeMatchesItemType((ProfileType)t, itemType);
    }

    private boolean profileTypeMatchesItemType(ProfileType pt, String itemType) {
        Collection supportedItemTypesOnProfileType = pt.getSupportedItemTypes();
        return supportedItemTypesOnProfileType.size() == 0 || supportedItemTypesOnProfileType.contains(ItemUtil.getMainItemType((String)itemType)) || supportedItemTypesOnProfileType.contains(itemType);
    }

    private boolean triggerProfileMatchesProfileType(ProfileType profileType, ChannelType channelType) {
        if (profileType instanceof TriggerProfileType) {
            TriggerProfileType triggerProfileType = (TriggerProfileType)profileType;
            if (triggerProfileType.getSupportedChannelTypeUIDs().size() == 0) {
                return true;
            }
            if (triggerProfileType.getSupportedChannelTypeUIDs().contains(channelType.getUID())) {
                return true;
            }
        }
        return false;
    }

    private boolean stateProfileMatchesProfileType(ProfileType profileType, ChannelType channelType) {
        if (profileType instanceof StateProfileType) {
            StateProfileType stateProfileType = (StateProfileType)profileType;
            if (stateProfileType.getSupportedItemTypesOfChannel().size() == 0) {
                return true;
            }
            Collection supportedItemTypesOfChannelOnProfileType = stateProfileType.getSupportedItemTypesOfChannel();
            if (supportedItemTypesOfChannelOnProfileType.contains(ItemUtil.getMainItemType((String)channelType.getItemType())) || supportedItemTypesOfChannelOnProfileType.contains(channelType.getItemType())) {
                return true;
            }
        }
        return false;
    }

    private ProfileTypeDTO convertToProfileTypeDTO(ProfileType profileType, Locale locale) {
        ProfileTypeDTO profileTypeDTO = ProfileTypeDTOMapper.map((ProfileType)profileType);
        if (profileTypeDTO != null) {
            return profileTypeDTO;
        }
        this.logger.warn("Cannot create DTO for profileType '{}'. Skipping it.", (Object)profileTypeDTO);
        return null;
    }

    public boolean isSatisfied() {
        return this.profileTypeRegistry != null && this.channelTypeRegistry != null;
    }

    @Reference
    protected void setLocaleService(LocaleService localeService) {
        this.localeService = localeService;
    }

    protected void unsetLocaleService(LocaleService localeService) {
        this.localeService = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setProfileTypeRegistry(ProfileTypeRegistry registry) {
        this.profileTypeRegistry = registry;
    }

    protected void unsetProfileTypeRegistry(ProfileTypeRegistry registry) {
        this.profileTypeRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setChannelTypeRegistry(ChannelTypeRegistry registry) {
        this.channelTypeRegistry = registry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry registry) {
        this.channelTypeRegistry = null;
    }
}

