/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.ConfigUtil;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.core.config.ConfigurationService;
import org.eclipse.smarthome.io.rest.core.internal.RESTCoreActivator;
import org.eclipse.smarthome.io.rest.core.service.ConfigurableServiceDTO;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="services")
@RolesAllowed(value={"administrator"})
@Api(value="services")
@Component(service={RESTResource.class, ConfigurableServiceResource.class})
public class ConfigurableServiceResource
implements RESTResource {
    public static final String PATH_SERVICES = "services";
    private static final String CONFIGURABLE_SERVICE_FILTER = "(&(service.config.description.uri=*)(!(esh.factoryservice=*)))";
    private static final String CONFIGURABLE_MULTI_CONFIG_SERVICE_FILTER = "(esh.factoryservice=*)";
    private final Logger logger = LoggerFactory.getLogger(ConfigurableServiceResource.class);
    private ConfigurationService configurationService;
    private ConfigDescriptionRegistry configDescRegistry;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all configurable services.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ConfigurableServiceDTO.class, responseContainer="List")})
    public List<ConfigurableServiceDTO> getAll() {
        List<ConfigurableServiceDTO> services = this.getConfigurableServices();
        return services;
    }

    @GET
    @Path(value="/{serviceId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get configurable service for given service ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ConfigurableServiceDTO.class), @ApiResponse(code=404, message="Not found")})
    public Response getById(@PathParam(value="serviceId") @ApiParam(value="service ID", required=true) String serviceId) {
        ConfigurableServiceDTO configurableService = this.getServiceById(serviceId);
        if (configurableService != null) {
            return Response.ok((Object)configurableService).build();
        }
        return Response.status((int)404).build();
    }

    private ConfigurableServiceDTO getServiceById(String serviceId) {
        ConfigurableServiceDTO multiService = this.getMultiConfigServiceById(serviceId);
        if (multiService != null) {
            return multiService;
        }
        List<ConfigurableServiceDTO> configurableServices = this.getConfigurableServices();
        for (ConfigurableServiceDTO configurableService : configurableServices) {
            if (!configurableService.id.equals(serviceId)) continue;
            return configurableService;
        }
        return null;
    }

    private ConfigurableServiceDTO getMultiConfigServiceById(String serviceId) {
        String filter = "(&(service.pid=" + serviceId + ")(" + "service.factoryPid" + "=*))";
        List<ConfigurableServiceDTO> services = this.getServicesByFilter(filter);
        if (services.size() == 1) {
            return services.get(0);
        }
        return null;
    }

    @GET
    @Path(value="/{serviceId}/contexts")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get existing multiple context service configurations for the given factory PID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ConfigurableServiceDTO.class, responseContainer="List")})
    public List<ConfigurableServiceDTO> getMultiConfigServicesByFactoryPid(@PathParam(value="serviceId") @ApiParam(value="service ID", required=true) String serviceId) {
        List<ConfigurableServiceDTO> services = this.collectServicesById(serviceId);
        return services;
    }

    private List<ConfigurableServiceDTO> collectServicesById(String serviceId) {
        String filter = "(service.factoryPid=" + serviceId + ")";
        return this.getServicesByFilter(filter);
    }

    @GET
    @Path(value="/{serviceId}/config")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get service configuration for given service ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=500, message="Configuration can not be read due to internal error")})
    public Response getConfiguration(@PathParam(value="serviceId") @ApiParam(value="service ID", required=true) String serviceId) {
        try {
            Configuration configuration = this.configurationService.get(serviceId);
            return configuration != null ? Response.ok((Object)configuration.getProperties()).build() : Response.ok(Collections.emptyMap()).build();
        }
        catch (IOException ex) {
            this.logger.error("Cannot get configuration for service {}: ", (Object)serviceId, (Object)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Path(value="/{serviceId}/config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates a service configuration for given service ID and returns the old configuration.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=204, message="No old configuration"), @ApiResponse(code=500, message="Configuration can not be updated due to internal error")})
    public Response updateConfiguration(@PathParam(value="serviceId") @ApiParam(value="service ID", required=true) String serviceId, Map<String, Object> configuration) {
        try {
            Configuration oldConfiguration = this.configurationService.get(serviceId);
            this.configurationService.update(serviceId, new Configuration(this.normalizeConfiguration(configuration, serviceId)));
            return oldConfiguration != null ? Response.ok((Object)oldConfiguration.getProperties()).build() : Response.noContent().build();
        }
        catch (IOException ex) {
            this.logger.error("Cannot update configuration for service {}: {}", new Object[]{serviceId, ex.getMessage(), ex});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Map<String, Object> normalizeConfiguration(Map<String, Object> properties, String serviceId) {
        URI uri;
        if (properties == null || properties.isEmpty()) {
            return properties;
        }
        ConfigurableServiceDTO service = this.getServiceById(serviceId);
        if (service == null) {
            return properties;
        }
        try {
            uri = new URI(service.configDescriptionURI);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.logger.warn("Not a valid URI: {}", (Object)service.configDescriptionURI);
            return properties;
        }
        ConfigDescription configDesc = this.configDescRegistry.getConfigDescription(uri);
        if (configDesc == null) {
            return properties;
        }
        return ConfigUtil.normalizeTypes(properties, Collections.singletonList(configDesc));
    }

    @DELETE
    @Path(value="/{serviceId}/config")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes a service configuration for given service ID and returns the old configuration.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=204, message="No old configuration"), @ApiResponse(code=500, message="Configuration can not be deleted due to internal error")})
    public Response deleteConfiguration(@PathParam(value="serviceId") @ApiParam(value="service ID", required=true) String serviceId) {
        try {
            Configuration oldConfiguration = this.configurationService.get(serviceId);
            this.configurationService.delete(serviceId);
            return oldConfiguration != null ? Response.ok((Object)oldConfiguration).build() : Response.noContent().build();
        }
        catch (IOException ex) {
            this.logger.error("Cannot delete configuration for service {}: {}", new Object[]{serviceId, ex.getMessage(), ex});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private List<ConfigurableServiceDTO> getServicesByFilter(String filter) {
        ArrayList<ConfigurableServiceDTO> services = new ArrayList<ConfigurableServiceDTO>();
        ServiceReference[] serviceReferences = null;
        try {
            serviceReferences = RESTCoreActivator.getBundleContext().getServiceReferences(null, filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            this.logger.error("Cannot get service references because the syntax of the filter '{}' is invalid.", (Object)filter);
        }
        if (serviceReferences != null) {
            ServiceReference[] serviceReferenceArray = serviceReferences;
            int n = serviceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference serviceReference = serviceReferenceArray[n2];
                String id = this.getServiceId(serviceReference);
                String label = (String)serviceReference.getProperty("service.config.label");
                if (label == null) {
                    label = this.configurationService.getProperty(id, "esh.servicecontext");
                }
                String category = (String)serviceReference.getProperty("service.config.category");
                String configDescriptionURI = (String)serviceReference.getProperty("service.config.description.uri");
                if (configDescriptionURI == null) {
                    String factoryPid = (String)serviceReference.getProperty("service.factoryPid");
                    configDescriptionURI = this.getConfigDescriptionByFactoryPid(factoryPid);
                }
                boolean multiple = Boolean.parseBoolean((String)serviceReference.getProperty("esh.factoryservice"));
                services.add(new ConfigurableServiceDTO(id, label, category, configDescriptionURI, multiple));
                ++n2;
            }
        }
        return services;
    }

    private String getConfigDescriptionByFactoryPid(String factoryPid) {
        String configDescriptionURI = null;
        String filter = "(service.pid=" + factoryPid + ")";
        try {
            ServiceReference[] refs = RESTCoreActivator.getBundleContext().getServiceReferences(null, filter);
            if (refs != null && refs.length > 0) {
                configDescriptionURI = (String)refs[0].getProperty("service.config.description.uri");
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            this.logger.error("Cannot get service references because the syntax of the filter '{}' is invalid.", (Object)filter);
        }
        return configDescriptionURI;
    }

    private List<ConfigurableServiceDTO> getConfigurableServices() {
        ArrayList<ConfigurableServiceDTO> services = new ArrayList<ConfigurableServiceDTO>();
        services.addAll(this.getServicesByFilter(CONFIGURABLE_SERVICE_FILTER));
        services.addAll(this.getServicesByFilter(CONFIGURABLE_MULTI_CONFIG_SERVICE_FILTER));
        return services;
    }

    private String getServiceId(ServiceReference<?> serviceReference) {
        Object pid = serviceReference.getProperty("service.pid");
        if (pid != null) {
            return (String)pid;
        }
        return (String)serviceReference.getProperty("component.name");
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected void unsetConfigurationService(ConfigurationService configurationService) {
        this.configurationService = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescRegistry = null;
    }

    public boolean isSatisfied() {
        return this.configurationService != null && this.configDescRegistry != null;
    }
}

