/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.log.internal;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/log")
@Api(value="log")
@Produces(value={"application/json"})
@Component
public class LogHandler
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(LogHandler.class);
    public static final String PATH_LOG = "log";
    private static final String TEMPLATE_INTERNAL_ERROR = "{\"error\":\"%s\",\"severity\":\"%s\"}";
    private final ConcurrentLinkedDeque<LogMessage> LOG_BUFFER = new ConcurrentLinkedDeque();

    @GET
    @Path(value="/levels")
    @ApiOperation(value="Get log severities, which are logged by the current logger settings.", code=200, notes="This depends on the current log settings at the backend.")
    public Response getLogLevels() {
        return Response.ok(this.createLogLevelsMap()).build();
    }

    @GET
    @ApiOperation(value="Returns the last logged frontend messages. The amount is limited to the 500 last entries.")
    @ApiParam(name="limit", allowableValues="range[1, 500]")
    public Response getLastLogs(@DefaultValue(value="500") @QueryParam(value="limit") Integer limit) {
        if (this.LOG_BUFFER.size() <= 0) {
            return Response.ok((Object)"[]").build();
        }
        int effectiveLimit = limit == null || limit <= 0 || limit > 500 ? this.LOG_BUFFER.size() : limit.intValue();
        if (effectiveLimit >= this.LOG_BUFFER.size()) {
            return Response.ok((Object)this.LOG_BUFFER.toArray()).build();
        }
        ArrayList<LogMessage> result = new ArrayList<LogMessage>();
        Iterator<LogMessage> iter = this.LOG_BUFFER.descendingIterator();
        do {
            result.add(iter.next());
        } while (iter.hasNext() && result.size() < effectiveLimit);
        Collections.reverse(result);
        return Response.ok(result).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Log a frontend log message to the backend.")
    @ApiParam(name="logMessage", value="Severity is required and can be one of error, warn, info or debug, depending on activated severities which you can GET at /logLevels.", example="{\"severity\": \"error\", \"url\": \"http://example.org\", \"message\": \"Error message\"}")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Your log severity is not supported.")})
    public Response log(LogMessage logMessage) {
        if (logMessage == null) {
            this.logger.debug("Received null log message model!");
            return Response.status((int)500).entity((Object)String.format(TEMPLATE_INTERNAL_ERROR, "Internal logging error.", "ERROR")).build();
        }
        logMessage.timestamp = Calendar.getInstance().getTimeInMillis();
        if (!this.doLog(logMessage)) {
            return Response.status((int)403).entity((Object)String.format(TEMPLATE_INTERNAL_ERROR, "Your log severity is not supported.", logMessage.severity)).build();
        }
        this.LOG_BUFFER.add(logMessage);
        if (this.LOG_BUFFER.size() > 500) {
            this.LOG_BUFFER.pollLast();
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    private boolean doLog(LogMessage logMessage) {
        switch (logMessage.severity.toLowerCase()) {
            case "error": {
                this.logger.error("Frontend Log ({}): {}", (Object)logMessage.url, (Object)logMessage.message);
                break;
            }
            case "warn": {
                this.logger.warn("Frontend Log ({}): {}", (Object)logMessage.url, (Object)logMessage.message);
                break;
            }
            case "info": {
                this.logger.info("Frontend Log ({}): {}", (Object)logMessage.url, (Object)logMessage.message);
                break;
            }
            case "debug": {
                this.logger.debug("Frontend Log ({}): {}", (Object)logMessage.url, (Object)logMessage.message);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private Map<String, Boolean> createLogLevelsMap() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("error", this.logger.isErrorEnabled());
        result.put("warn", this.logger.isWarnEnabled());
        result.put("info", this.logger.isInfoEnabled());
        result.put("debug", this.logger.isDebugEnabled());
        return result;
    }

    public class LogMessage {
        public long timestamp;
        public String severity;
        public URL url;
        public String message;
    }
}

