/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest;

import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.io.rest.LocaleService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@NonNullByDefault
public class LocaleServiceImpl
implements LocaleService {
    private final Logger logger = LoggerFactory.getLogger(LocaleServiceImpl.class);
    private volatile @Nullable LocaleProvider localeProvider;

    @Override
    public Locale getLocale(@Nullable String acceptLanguageHttpHeader) {
        Locale locale = this.tryGetLocale();
        if (acceptLanguageHttpHeader != null) {
            int pos = acceptLanguageHttpHeader.indexOf(44);
            String[] split = pos > -1 ? acceptLanguageHttpHeader.substring(0, pos).split("-") : acceptLanguageHttpHeader.split("-");
            locale = split.length == 2 ? new Locale(split[0], split[1]) : new Locale(split[0]);
        }
        return locale;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setLocaleProvider(LocaleProvider provider) {
        this.logger.debug("The localeProvider in LocaleUtilService has been set");
        this.localeProvider = provider;
    }

    protected void unsetLocaleProvider(LocaleProvider provider) {
        this.logger.debug("The localeProvider in LocaleUtilService has been unset");
        this.localeProvider = null;
    }

    private Locale tryGetLocale() {
        LocaleProvider provider = this.localeProvider;
        if (provider != null) {
            return provider.getLocale();
        }
        this.logger.error("There should ALWAYS be a local provider available, as it is provided by the core.");
        return Locale.US;
    }
}

