/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mqtt.internal;

import java.util.concurrent.CompletableFuture;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.smarthome.io.transport.mqtt.MqttActionCallback;

public class MqttActionAdapterCallback
implements IMqttActionListener {
    public void onSuccess(IMqttToken token) {
        if (token.getUserContext() instanceof MqttActionCallback) {
            MqttActionCallback subscriber = (MqttActionCallback)token.getUserContext();
            subscriber.onSuccess(token.getTopics()[0]);
        } else if (token.getUserContext() instanceof CompletableFuture) {
            CompletableFuture future = (CompletableFuture)token.getUserContext();
            future.complete(true);
        }
    }

    public void onFailure(IMqttToken token, Throwable throwable) {
        if (token.getUserContext() instanceof MqttActionCallback) {
            MqttActionCallback subscriber = (MqttActionCallback)token.getUserContext();
            subscriber.onFailure(token.getTopics()[0], throwable);
        } else if (token.getUserContext() instanceof CompletableFuture) {
            CompletableFuture future = (CompletableFuture)token.getUserContext();
            future.completeExceptionally(throwable);
        }
    }
}

