/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.serial.rxtx.rfc2217.internal;

import gnu.io.rfc2217.TelnetSerialPort;
import java.net.URI;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.io.transport.serial.PortInUseException;
import org.eclipse.smarthome.io.transport.serial.SerialPort;
import org.eclipse.smarthome.io.transport.serial.SerialPortIdentifier;
import org.eclipse.smarthome.io.transport.serial.rxtx.RxTxSerialPort;

@NonNullByDefault
public class SerialPortIdentifierImpl
implements SerialPortIdentifier {
    final TelnetSerialPort id;
    private final URI uri;

    public SerialPortIdentifierImpl(TelnetSerialPort id, URI uri) {
        this.id = id;
        this.uri = uri;
    }

    public String getName() {
        String name = this.id.getName();
        return name != null ? name : "";
    }

    public SerialPort open(String owner, int timeout) throws PortInUseException {
        try {
            this.id.getTelnetClient().setConnectTimeout(timeout);
            this.id.getTelnetClient().connect(this.uri.getHost(), this.uri.getPort());
            return new RxTxSerialPort((gnu.io.SerialPort)this.id);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to establish remote connection to serial port %s", this.uri), e);
        }
    }

    public boolean isCurrentlyOwned() {
        return !this.id.getTelnetClient().isAvailable();
    }

    public @Nullable String getCurrentOwner() {
        return null;
    }
}

