/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.serial.internal;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class SerialPortUtil {
    private static final String GNU_IO_RXTX_SERIAL_PORTS = "gnu.io.rxtx.SerialPorts";

    public static synchronized void appendSerialPortProperty(String port) {
        String serialPortsProperty = System.getProperty(GNU_IO_RXTX_SERIAL_PORTS);
        String newValue = SerialPortUtil.initSerialPort(port, serialPortsProperty);
        if (newValue != null) {
            System.setProperty(GNU_IO_RXTX_SERIAL_PORTS, newValue);
        }
    }

    static @Nullable String initSerialPort(String port, @Nullable String serialPortsProperty) {
        String pathSeparator = File.pathSeparator;
        Set<Object> serialPorts = null;
        serialPorts = serialPortsProperty != null ? Stream.of(serialPortsProperty.split(pathSeparator)).collect(Collectors.toSet()) : new HashSet<String>();
        if (serialPorts.add(port)) {
            return serialPorts.stream().collect(Collectors.joining(pathSeparator));
        }
        return null;
    }
}

