/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.lsp.internal;

import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.smarthome.model.ide.ItemsIdeSetup;
import org.eclipse.smarthome.model.ide.SitemapIdeSetup;
import org.eclipse.smarthome.model.persistence.ide.PersistenceIdeSetup;
import org.eclipse.smarthome.model.rule.ide.RulesIdeSetup;
import org.eclipse.smarthome.model.script.ScriptServiceUtil;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.smarthome.model.script.ide.ScriptIdeSetup;
import org.eclipse.smarthome.model.thing.ide.ThingIdeSetup;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.BinaryGrammarResourceFactoryImpl;
import org.eclipse.xtext.resource.impl.ResourceServiceProviderRegistryImpl;

@Singleton
public class RegistryProvider
implements Provider<IResourceServiceProvider.Registry> {
    private IResourceServiceProvider.Registry registry;
    private final ScriptServiceUtil scriptServiceUtil;
    private final ScriptEngine scriptEngine;

    public RegistryProvider(ScriptServiceUtil scriptServiceUtil, ScriptEngine scriptEngine) {
        this.scriptServiceUtil = scriptServiceUtil;
        this.scriptEngine = scriptEngine;
    }

    public synchronized IResourceServiceProvider.Registry get() {
        if (this.registry == null) {
            this.registry = this.createRegistry();
        }
        return this.registry;
    }

    private IResourceServiceProvider.Registry createRegistry() {
        this.registerDefaultFactories();
        ResourceServiceProviderRegistryImpl registry = new ResourceServiceProviderRegistryImpl();
        this.register((IResourceServiceProvider.Registry)registry, new ItemsIdeSetup().createInjector());
        this.register((IResourceServiceProvider.Registry)registry, new PersistenceIdeSetup().createInjector());
        this.register((IResourceServiceProvider.Registry)registry, new RulesIdeSetup().setScriptServiceUtil(this.scriptServiceUtil).setScriptEngine(this.scriptEngine).createInjector());
        this.register((IResourceServiceProvider.Registry)registry, new ScriptIdeSetup().setScriptServiceUtil(this.scriptServiceUtil).setScriptEngine(this.scriptEngine).createInjector());
        this.register((IResourceServiceProvider.Registry)registry, new SitemapIdeSetup().createInjector());
        this.register((IResourceServiceProvider.Registry)registry, new ThingIdeSetup().createInjector());
        return registry;
    }

    private void registerDefaultFactories() {
        if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("ecore")) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        }
        if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("xmi")) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        }
        if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("xtextbin")) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xtextbin", new BinaryGrammarResourceFactoryImpl());
        }
        if (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.eclipse.org/2008/Xtext")) {
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/2008/Xtext", (Object)XtextPackage.eINSTANCE);
        }
    }

    private void register(IResourceServiceProvider.Registry registry, Injector injector) {
        IResourceServiceProvider resourceServiceProvider = (IResourceServiceProvider)injector.getInstance(IResourceServiceProvider.class);
        FileExtensionProvider extensionProvider = (FileExtensionProvider)injector.getInstance(FileExtensionProvider.class);
        for (String ext : extensionProvider.getFileExtensions()) {
            if (registry.getExtensionToFactoryMap().containsKey(ext)) {
                if (extensionProvider.getPrimaryFileExtension() == ext) {
                    registry.getExtensionToFactoryMap().put(ext, resourceServiceProvider);
                }
            } else {
                registry.getExtensionToFactoryMap().put(ext, resourceServiceProvider);
            }
            IResourceFactory resourceFactory = (IResourceFactory)injector.getInstance(IResourceFactory.class);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(ext, resourceFactory);
        }
    }
}

