/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.storage.json.internal;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.storage.Storage;
import org.eclipse.smarthome.core.storage.StorageService;
import org.eclipse.smarthome.storage.json.internal.JsonStorage;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonStorageService
implements StorageService {
    private static final int MAX_FILENAME_LENGTH = 127;
    private final Logger logger = LoggerFactory.getLogger(JsonStorageService.class);
    private String dbFolderName = "jsondb";
    private final String CFG_MAX_BACKUP_FILES = "backup_files";
    private final String CFG_WRITE_DELAY = "write_delay";
    private final String CFG_MAX_DEFER_DELAY = "max_defer_delay";
    private int maxBackupFiles = 5;
    private int writeDelay = 500;
    private int maxDeferredPeriod = 60000;
    private final Map<String, JsonStorage<Object>> storageList = new HashMap<String, JsonStorage<Object>>();

    protected void activate(ComponentContext cContext, Map<String, Object> properties) {
        File backup;
        this.dbFolderName = String.valueOf(ConfigConstants.getUserDataFolder()) + File.separator + this.dbFolderName;
        File folder = new File(this.dbFolderName);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(backup = new File(this.dbFolderName, "backup")).exists()) {
            backup.mkdirs();
        }
        this.logger.debug("Json Storage Service: Activated.");
        if (properties == null || properties.isEmpty()) {
            return;
        }
        try {
            if (properties.get("backup_files") != null) {
                this.maxBackupFiles = Integer.parseInt((String)properties.get("backup_files"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.error("Value {} for {} is invalid. Using {}.", new Object[]{properties.get("backup_files"), "backup_files", this.maxBackupFiles});
        }
        try {
            if (properties.get("write_delay") != null) {
                this.writeDelay = Integer.parseInt((String)properties.get("write_delay"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.error("Value {} for {} is invalid. Using {}.", new Object[]{properties.get("write_delay"), "write_delay", this.writeDelay});
        }
        try {
            if (properties.get("max_defer_delay") != null) {
                this.maxDeferredPeriod = Integer.parseInt((String)properties.get("max_defer_delay"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.error("Value {} for {} is invalid. Using {}.", new Object[]{properties.get("max_defer_delay"), "max_defer_delay", this.maxDeferredPeriod});
        }
    }

    protected void deactivate() {
        for (JsonStorage<Object> storage : this.storageList.values()) {
            storage.commitDatabase();
        }
        this.logger.debug("Json Storage Service: Deactivated.");
    }

    public <T> Storage<T> getStorage(String name, ClassLoader classLoader) {
        JsonStorage newStorage;
        JsonStorage oldStorage;
        File escapedFile;
        File legacyFile = new File(this.dbFolderName, String.valueOf(name) + ".json");
        File file = escapedFile = new File(this.dbFolderName, String.valueOf(this.urlEscapeUnwantedChars(name)) + ".json");
        if (legacyFile.exists()) {
            file = legacyFile;
        }
        if ((oldStorage = this.storageList.put(name, newStorage = new JsonStorage(file, classLoader, this.maxBackupFiles, this.writeDelay, this.maxDeferredPeriod))) != null) {
            oldStorage.commitDatabase();
        }
        return newStorage;
    }

    public <T> Storage<T> getStorage(String name) {
        return this.getStorage(name, null);
    }

    protected String urlEscapeUnwantedChars(String s) {
        String result;
        try {
            result = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.warn("Encoding UTF-8 is not supported, might generate invalid filenames.");
            result = s;
        }
        int length = Math.min(result.length(), 127);
        return result.substring(0, length);
    }
}

