/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.test.java;

import org.eclipse.smarthome.test.java.JavaTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JavaTestTest {
    private JavaTest javaTest;

    @Before
    public void setup() {
        this.javaTest = new JavaTest();
    }

    @Test
    public void waitForAssertShouldRunAfterLastCall_whenAssertionSucceeds() {
        Runnable afterLastCall = (Runnable)Mockito.mock(Runnable.class);
        this.javaTest.waitForAssert(() -> Assert.assertTrue((boolean)true), null, afterLastCall, 100L, 50L);
        ((Runnable)Mockito.verify((Object)afterLastCall, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void waitForAssertShouldRunAfterLastCall_whenAssertionFails() {
        Runnable afterLastCall = (Runnable)Mockito.mock(Runnable.class);
        try {
            this.javaTest.waitForAssert(() -> Assert.assertTrue((boolean)false), null, afterLastCall, 100L, 50L);
        }
        catch (AssertionError assertionError) {}
        ((Runnable)Mockito.verify((Object)afterLastCall, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test(expected=NullPointerException.class)
    public void waitForAssertShouldNotCatchNPE() {
        this.javaTest.waitForAssert(() -> this.getObject().getClass());
    }

    private Object getObject() {
        return null;
    }
}

