/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.classic.internal.render;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.library.types.RawType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Image;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.classic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.classic.render.RenderException;
import org.eclipse.smarthome.ui.classic.render.WidgetRenderer;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WidgetRenderer.class})
public class ImageRenderer
extends AbstractWidgetRenderer {
    @Override
    public boolean canRender(Widget w) {
        return w instanceof Image;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        Image image = (Image)w;
        String snippet = image.getChildren().size() > 0 ? this.getSnippet("image_link") : this.getSnippet("image");
        snippet = image.getRefresh() > 0 ? StringUtils.replace((String)snippet, (String)"%refresh%", (String)("id=\"%id%\" data-timeout=\"" + image.getRefresh() + "\" onload=\"startReloadImage('%url%', '%id%')\"")) : StringUtils.replace((String)snippet, (String)"%refresh%", (String)"");
        String widgetId = this.itemUIRegistry.getWidgetId(w);
        snippet = StringUtils.replace((String)snippet, (String)"%id%", (String)widgetId);
        String sitemap = null;
        if (w.eResource() != null) {
            sitemap = w.eResource().getURI().path();
        }
        boolean validUrl = this.isValidURL(image.getUrl());
        String proxiedUrl = "../proxy?sitemap=" + sitemap + "&widgetId=" + widgetId;
        State state = this.itemUIRegistry.getState(w);
        String url = state instanceof RawType ? state.toFullString() : (sitemap != null && (state instanceof StringType || validUrl) ? String.valueOf(proxiedUrl) + "&t=" + new Date().getTime() : "images/none.png");
        snippet = StringUtils.replace((String)snippet, (String)"%url%", (String)url);
        sb.append(snippet);
        return null;
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

