/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.icon.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.io.rest.LocaleService;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.ui.icon.IconProvider;
import org.eclipse.smarthome.ui.icon.IconSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Path(value="iconsets")
@Component
public class IconSetResource
implements RESTResource {
    private List<IconProvider> iconProviders = new ArrayList<IconProvider>(5);
    private LocaleService localeService;
    @Context
    UriInfo uriInfo;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addIconProvider(IconProvider iconProvider) {
        this.iconProviders.add(iconProvider);
    }

    protected void removeIconProvider(IconProvider iconProvider) {
        this.iconProviders.remove(iconProvider);
    }

    @Reference
    protected void setLocaleService(LocaleService localeService) {
        this.localeService = localeService;
    }

    protected void unsetLocaleService(LocaleService localeService) {
        this.localeService = null;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAll(@HeaderParam(value="Accept-Language") String language) {
        Locale locale = this.localeService.getLocale(language);
        ArrayList<IconSet> iconSets = new ArrayList<IconSet>(this.iconProviders.size());
        for (IconProvider iconProvider : this.iconProviders) {
            iconSets.addAll(iconProvider.getIconSets(locale));
        }
        return Response.ok(iconSets).build();
    }
}

