/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.smarthome.binding.hue.HueBindingConstants;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.UpnpDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.jupnp.model.meta.RemoteDevice;

public class HueBridgeDiscoveryParticipant
implements UpnpDiscoveryParticipant {
    public Set<ThingTypeUID> getSupportedThingTypeUIDs() {
        return Collections.singleton(HueBindingConstants.THING_TYPE_BRIDGE);
    }

    public DiscoveryResult createResult(RemoteDevice device) {
        ThingUID uid = this.getThingUID(device);
        if (uid != null) {
            HashMap<String, String> properties = new HashMap<String, String>(2);
            properties.put("ipAddress", device.getDetails().getBaseURL().getHost());
            properties.put("serialNumber", device.getDetails().getSerialNumber());
            DiscoveryResult result = DiscoveryResultBuilder.create((ThingUID)uid).withProperties(properties).withLabel(device.getDetails().getFriendlyName()).build();
            return result;
        }
        return null;
    }

    public ThingUID getThingUID(RemoteDevice device) {
        if (device.getDetails().getModelDetails().getModelName().startsWith("Philips hue bridge")) {
            return new ThingUID(HueBindingConstants.THING_TYPE_BRIDGE, device.getDetails().getSerialNumber());
        }
        return null;
    }
}

