/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.discovery;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Set;
import nl.q42.jue.FullLight;
import nl.q42.jue.HueBridge;
import org.eclipse.smarthome.binding.hue.HueBindingConstants;
import org.eclipse.smarthome.binding.hue.internal.handler.HueBridgeHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.LightStatusListener;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HueLightDiscoveryService
extends AbstractDiscoveryService
implements LightStatusListener {
    private static final Logger logger = LoggerFactory.getLogger(HueLightDiscoveryService.class);
    private HueBridgeHandler hueBridgeHandler;

    public HueLightDiscoveryService(HueBridgeHandler hueBridgeHandler) {
        super(5);
        this.hueBridgeHandler = hueBridgeHandler;
    }

    public void activate() {
        this.hueBridgeHandler.registerLightStatusListener(this);
    }

    public void deactivate() {
        this.hueBridgeHandler.unregisterLightStatusListener(this);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return ImmutableSet.copyOf((Object[])new ThingTypeUID[]{HueBindingConstants.THING_TYPE_LCT001});
    }

    public int getScanTimeout() {
        return 1;
    }

    public void startScan() {
    }

    @Override
    public void onLightAdded(HueBridge bridge, FullLight light) {
        ThingUID thingUID = this.getThingUID(light);
        if (thingUID != null) {
            ThingUID bridgeUID = this.hueBridgeHandler.getThing().getUID();
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("lightId", light.getId());
            DiscoveryResult discoveryResult = DiscoveryResultBuilder.create((ThingUID)thingUID).withProperties(properties).withBridge(bridgeUID).withLabel(light.getName()).build();
            this.thingDiscovered(discoveryResult);
        } else {
            logger.debug("discovered unsupported light of type '{}' with id {}", (Object)light.getModelID(), (Object)light.getId());
        }
    }

    @Override
    public void onLightRemoved(HueBridge bridge, FullLight light) {
        ThingUID thingUID = this.getThingUID(light);
        if (thingUID != null) {
            this.thingRemoved(thingUID);
        }
    }

    @Override
    public void onLightStateChanged(HueBridge bridge, FullLight light) {
    }

    private ThingUID getThingUID(FullLight light) {
        ThingUID bridgeUID = this.hueBridgeHandler.getThing().getUID();
        ThingTypeUID thingTypeUID = null;
        switch (light.getModelID()) {
            case "LCT001": {
                thingTypeUID = HueBindingConstants.THING_TYPE_LCT001;
            }
        }
        if (thingTypeUID != null) {
            String thingLightId = "Light" + light.getId();
            ThingUID thingUID = new ThingUID(thingTypeUID, bridgeUID, thingLightId);
            return thingUID;
        }
        return null;
    }
}

