/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.factory;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.smarthome.binding.hue.HueBindingConstants;
import org.eclipse.smarthome.binding.hue.internal.discovery.HueLightDiscoveryService;
import org.eclipse.smarthome.binding.hue.internal.handler.HueBridgeHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.HueLightHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.osgi.framework.ServiceRegistration;

public class HueThingHandlerFactory
extends BaseThingHandlerFactory {
    public static final Collection<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Lists.newArrayList((Object[])new ThingTypeUID[]{HueBindingConstants.THING_TYPE_LCT001, HueBindingConstants.THING_TYPE_BRIDGE});
    private ServiceRegistration<?> discoveryServiceReg;

    public Thing createThing(ThingTypeUID thingTypeUID, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID) {
        if (HueBindingConstants.THING_TYPE_BRIDGE.equals((Object)thingTypeUID)) {
            ThingUID hueBridgeUID = this.getBridgeThingUID(thingTypeUID, thingUID, configuration);
            return super.createThing(thingTypeUID, configuration, hueBridgeUID, null);
        }
        if (HueBindingConstants.THING_TYPE_LCT001.equals((Object)thingTypeUID)) {
            ThingUID hueLightUID = this.getLightUID(thingTypeUID, thingUID, configuration, bridgeUID);
            return super.createThing(thingTypeUID, configuration, hueLightUID, bridgeUID);
        }
        throw new IllegalArgumentException("The thing type " + thingTypeUID + " is not supported by the hue binding.");
    }

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    private ThingUID getBridgeThingUID(ThingTypeUID thingTypeUID, ThingUID thingUID, Configuration configuration) {
        if (thingUID == null) {
            String serialNumber = (String)configuration.get((Object)"serialNumber");
            thingUID = new ThingUID(thingTypeUID, serialNumber);
        }
        return thingUID;
    }

    private ThingUID getLightUID(ThingTypeUID thingTypeUID, ThingUID thingUID, Configuration configuration, ThingUID bridgeUID) {
        String lightId = (String)configuration.get((Object)"lightId");
        if (thingUID == null) {
            thingUID = new ThingUID(thingTypeUID, "Light" + lightId, new String[]{bridgeUID.getId()});
        }
        return thingUID;
    }

    protected ThingHandler createHandler(Thing thing) {
        if (thing.getThingTypeUID().equals((Object)HueBindingConstants.THING_TYPE_BRIDGE)) {
            HueBridgeHandler handler = new HueBridgeHandler((Bridge)thing);
            this.registerLightDiscoveryService(handler);
            return handler;
        }
        if (thing.getThingTypeUID().equals((Object)HueBindingConstants.THING_TYPE_LCT001)) {
            return new HueLightHandler(thing);
        }
        return null;
    }

    private void registerLightDiscoveryService(HueBridgeHandler bridgeHandler) {
        HueLightDiscoveryService discoveryService = new HueLightDiscoveryService(bridgeHandler);
        discoveryService.activate();
        this.discoveryServiceReg = this.bundleContext.registerService(DiscoveryService.class.getName(), (Object)discoveryService, new Hashtable());
    }

    protected void removeHandler(ThingHandler thingHandler) {
        if (this.discoveryServiceReg != null) {
            HueLightDiscoveryService service = (HueLightDiscoveryService)this.bundleContext.getService(this.discoveryServiceReg.getReference());
            service.deactivate();
            this.discoveryServiceReg.unregister();
            this.discoveryServiceReg = null;
        }
    }
}

