/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.handler;

import java.io.IOException;
import java.net.Inet4Address;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import nl.q42.jue.FullConfig;
import nl.q42.jue.FullLight;
import nl.q42.jue.HueBridge;
import nl.q42.jue.Light;
import nl.q42.jue.State;
import nl.q42.jue.StateUpdate;
import nl.q42.jue.exceptions.ApiException;
import nl.q42.jue.exceptions.UnauthorizedException;
import org.eclipse.smarthome.binding.hue.config.HueBridgeConfiguration;
import org.eclipse.smarthome.binding.hue.internal.handler.LightStatusListener;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HueBridgeHandler
extends BaseBridgeHandler {
    private static final int POLLING_FREQUENCY = 10;
    private static final String DEFAULT_USERNAME = "EclipseSmartHome";
    private Logger logger = LoggerFactory.getLogger(HueBridgeHandler.class);
    private Map<String, FullLight> lastLightsState = new HashMap<String, FullLight>();
    private boolean lastBridgeConnectionState = false;
    private List<LightStatusListener> lightStatusListeners = new CopyOnWriteArrayList<LightStatusListener>();
    private ScheduledFuture<?> pollingJob;
    private Runnable pollingRunnable = new Runnable(){

        @Override
        public void run() {
            block22: {
                try {
                    try {
                        FullConfig fullConfig = HueBridgeHandler.this.bridge.getFullConfig();
                        if (!HueBridgeHandler.this.lastBridgeConnectionState) {
                            HueBridgeHandler.this.logger.debug("Connection to Hue Bridge {} established.", (Object)HueBridgeHandler.this.bridge.getIPAddress());
                            HueBridgeHandler.this.lastBridgeConnectionState = true;
                            HueBridgeHandler.this.onConnectionResumed(HueBridgeHandler.this.bridge);
                        }
                        if (!HueBridgeHandler.this.lastBridgeConnectionState) break block22;
                        HashMap lastLightStateCopy = new HashMap(HueBridgeHandler.this.lastLightsState);
                        for (FullLight fullLight : fullConfig.getLights()) {
                            String lightId = fullLight.getId();
                            if (lastLightStateCopy.containsKey(lightId)) {
                                FullLight lastFullLight = (FullLight)lastLightStateCopy.remove(lightId);
                                State lastFullLightState = lastFullLight.getState();
                                HueBridgeHandler.this.lastLightsState.put(lightId, fullLight);
                                if (HueBridgeHandler.this.isEqual(lastFullLightState, fullLight.getState())) continue;
                                HueBridgeHandler.this.logger.debug("Status update for Hue light {} detected.", (Object)lightId);
                                for (LightStatusListener lightStatusListener : HueBridgeHandler.this.lightStatusListeners) {
                                    try {
                                        lightStatusListener.onLightStateChanged(HueBridgeHandler.this.bridge, fullLight);
                                    }
                                    catch (Exception e) {
                                        HueBridgeHandler.this.logger.error("An exception occurred while calling the BridgeHeartbeatListener", (Throwable)e);
                                    }
                                }
                                continue;
                            }
                            HueBridgeHandler.this.lastLightsState.put(lightId, fullLight);
                            HueBridgeHandler.this.logger.debug("Hue light {} added.", (Object)lightId);
                            for (LightStatusListener lightStatusListener : HueBridgeHandler.this.lightStatusListeners) {
                                try {
                                    lightStatusListener.onLightAdded(HueBridgeHandler.this.bridge, fullLight);
                                }
                                catch (Exception e) {
                                    HueBridgeHandler.this.logger.error("An exception occurred while calling the BridgeHeartbeatListener", (Throwable)e);
                                }
                            }
                        }
                        for (Map.Entry entry : lastLightStateCopy.entrySet()) {
                            HueBridgeHandler.this.lastLightsState.remove(entry.getKey());
                            HueBridgeHandler.this.logger.debug("Hue light {} removed.", entry.getKey());
                            for (LightStatusListener lightStatusListener : HueBridgeHandler.this.lightStatusListeners) {
                                try {
                                    lightStatusListener.onLightRemoved(HueBridgeHandler.this.bridge, (FullLight)entry.getValue());
                                }
                                catch (Exception e) {
                                    HueBridgeHandler.this.logger.error("An exception occurred while calling the BridgeHeartbeatListener", (Throwable)e);
                                }
                            }
                        }
                    }
                    catch (IllegalStateException | UnauthorizedException throwable) {
                        boolean isReachable = Inet4Address.getByName(HueBridgeHandler.this.bridge.getIPAddress()).isReachable(2000);
                        if (isReachable) {
                            HueBridgeHandler.this.lastBridgeConnectionState = false;
                            HueBridgeHandler.this.onNotAuthenticated(HueBridgeHandler.this.bridge);
                        } else if (HueBridgeHandler.this.lastBridgeConnectionState) {
                            HueBridgeHandler.this.lastBridgeConnectionState = false;
                            HueBridgeHandler.this.onConnectionLost(HueBridgeHandler.this.bridge);
                        }
                    }
                    catch (Exception exception) {
                        if (HueBridgeHandler.this.bridge != null && HueBridgeHandler.this.lastBridgeConnectionState) {
                            HueBridgeHandler.this.logger.debug("Connection to Hue Bridge {} lost.", (Object)HueBridgeHandler.this.bridge.getIPAddress());
                            HueBridgeHandler.this.lastBridgeConnectionState = false;
                            HueBridgeHandler.this.onConnectionLost(HueBridgeHandler.this.bridge);
                        }
                    }
                }
                catch (Throwable t) {
                    HueBridgeHandler.this.logger.error("An unexpected error occurred: {}", (Object)t.getMessage(), (Object)t);
                }
            }
        }
    };
    private HueBridge bridge = null;

    public HueBridgeHandler(Bridge hueBridge) {
        super(hueBridge);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public void updateLightState(Light light, StateUpdate stateUpdate) {
        if (this.bridge != null) {
            try {
                this.bridge.setLightState(light, stateUpdate);
            }
            catch (IOException | ApiException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalStateException e) {
                this.logger.trace("Error while accessing light: {}", (Object)e.getMessage());
            }
        } else {
            this.logger.warn("No bridge connected or selected. Cannot set light state.");
        }
    }

    public void dispose() {
        this.logger.debug("Handler disposed.");
        if (this.pollingJob != null && !this.pollingJob.isCancelled()) {
            this.pollingJob.cancel(true);
            this.pollingJob = null;
        }
        if (this.bridge != null) {
            this.bridge = null;
        }
    }

    public void initialize() {
        this.logger.debug("Initializing hue bridge handler.");
        HueBridgeConfiguration configuration = (HueBridgeConfiguration)this.getConfigAs(HueBridgeConfiguration.class);
        if (configuration.userName == null) {
            this.getConfig().put("userName", (Object)DEFAULT_USERNAME);
        }
        if (configuration.ipAddress != null) {
            if (this.bridge == null) {
                this.bridge = new HueBridge(configuration.ipAddress);
                this.bridge.setTimeout(5000);
            }
            this.onUpdate();
        } else {
            this.logger.warn("Cannot connect to hue bridge. IP address or user name not set.");
        }
    }

    private synchronized void onUpdate() {
        if (this.bridge != null && (this.pollingJob == null || this.pollingJob.isCancelled())) {
            this.pollingJob = this.scheduler.scheduleAtFixedRate(this.pollingRunnable, 0L, 10L, TimeUnit.SECONDS);
        }
    }

    public void onConnectionLost(HueBridge bridge) {
        this.logger.debug("Bridge connection lost. Updating thing status to OFFLINE.");
        this.updateStatus(ThingStatus.OFFLINE);
    }

    public void onConnectionResumed(HueBridge bridge) {
        this.logger.debug("Bridge connection resumed. Updating thing status to ONLINE.");
        this.updateStatus(ThingStatus.ONLINE);
    }

    public void onNotAuthenticated(HueBridge bridge) {
        HueBridgeConfiguration configuration = (HueBridgeConfiguration)this.getConfigAs(HueBridgeConfiguration.class);
        try {
            bridge.authenticate(configuration.userName);
        }
        catch (Exception exception) {
            this.logger.info("Hue bridge {} is not authenticated - please press the pairing button on the bridge.", (Object)configuration.ipAddress);
            try {
                bridge.link(configuration.userName, "gateway");
                this.logger.info("User '{}' has been successfully added to Hue bridge.", (Object)configuration.userName);
            }
            catch (Exception exception2) {
                this.logger.debug("Failed adding user '{}' to Hue bridge.", (Object)configuration.userName);
            }
        }
    }

    public boolean registerLightStatusListener(LightStatusListener lightStatusListener) {
        if (lightStatusListener == null) {
            throw new NullPointerException("It's not allowed to pass a null LightStatusListener.");
        }
        boolean result = this.lightStatusListeners.add(lightStatusListener);
        if (result) {
            this.onUpdate();
        }
        return result;
    }

    public boolean unregisterLightStatusListener(LightStatusListener lightStatusListener) {
        boolean result = this.lightStatusListeners.remove(lightStatusListener);
        if (result) {
            this.onUpdate();
        }
        return result;
    }

    public Light getLightById(String lightId) {
        try {
            List lights = this.bridge.getLights();
            for (Light light : lights) {
                if (!light.getId().equals(lightId)) continue;
                return light;
            }
        }
        catch (IOException | ApiException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalStateException e) {
            this.logger.trace("Error while accessing light: {}", (Object)e.getMessage());
        }
        return null;
    }

    private boolean isEqual(State state1, State state2) {
        try {
            return state1.getAlertMode().equals((Object)state2.getAlertMode()) && state1.isOn() == state2.isOn() && state1.getEffect().equals((Object)state2.getEffect()) && state1.getBrightness() == state2.getBrightness() && state1.getColorMode().equals((Object)state2.getColorMode()) && state1.getColorTemperature() == state2.getColorTemperature() && state1.getHue() == state2.getHue() && state1.getSaturation() == state2.getSaturation();
        }
        catch (Exception exception) {
            return true;
        }
    }
}

