/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.handler;

import nl.q42.jue.FullLight;
import nl.q42.jue.HueBridge;
import nl.q42.jue.Light;
import nl.q42.jue.StateUpdate;
import org.eclipse.smarthome.binding.hue.config.HueLightConfiguration;
import org.eclipse.smarthome.binding.hue.internal.handler.HueBridgeHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.LightStateConverter;
import org.eclipse.smarthome.binding.hue.internal.handler.LightStatusListener;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HueLightHandler
extends BaseThingHandler
implements LightStatusListener {
    public static final String CHANNEL_ID_COLOR = "color";
    public static final String CHANNEL_ID_COLOR_TEMPERATURE = "color_temperature";
    private final LightStateConverter lightStateConverter = new LightStateConverter();
    private Light light;
    private String lightId;
    private Logger logger = LoggerFactory.getLogger(HueLightHandler.class);
    private HueBridgeHandler bridgeHandler;

    public HueLightHandler(Thing hueLight) {
        super(hueLight);
    }

    public void initialize() {
        this.logger.debug("Initializing hue light handler.");
        String configLightId = ((HueLightConfiguration)this.getConfigAs(HueLightConfiguration.class)).lightId;
        if (configLightId != null) {
            this.lightId = configLightId;
            super.initialize();
        }
    }

    public void dispose() {
        this.logger.debug("Handler disposes. Unregistering listener.");
        if (this.lightId != null) {
            HueBridgeHandler bridgeHandler = this.getHueBridgeHandler();
            if (bridgeHandler != null) {
                this.getHueBridgeHandler().unregisterLightStatusListener(this);
            }
            this.lightId = null;
        }
    }

    private Light getLight() {
        HueBridgeHandler bridgeHandler;
        if (this.light == null && (bridgeHandler = this.getHueBridgeHandler()) != null) {
            this.light = bridgeHandler.getLightById(this.lightId);
        }
        return this.light;
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        HueBridgeHandler hueBridge = this.getHueBridgeHandler();
        if (hueBridge == null) {
            this.logger.warn("hue bridge handler not found. Cannot handle command without bridge.");
            return;
        }
        switch (channelUID.getId()) {
            case "color_temperature": {
                if (command instanceof PercentType) {
                    StateUpdate lightState = this.lightStateConverter.toColorTemperatureLightState((PercentType)command);
                    hueBridge.updateLightState(this.getLight(), lightState);
                    break;
                }
                if (!(command instanceof OnOffType)) break;
                StateUpdate lightState = this.lightStateConverter.toColorLightState((OnOffType)command);
                hueBridge.updateLightState(this.getLight(), lightState);
                break;
            }
            case "color": {
                if (command instanceof HSBType) {
                    StateUpdate lightState = this.lightStateConverter.toColorLightState((HSBType)command);
                    hueBridge.updateLightState(this.getLight(), lightState);
                    break;
                }
                if (command instanceof PercentType) {
                    StateUpdate lightState = this.lightStateConverter.toColorLightState((PercentType)command);
                    hueBridge.updateLightState(this.getLight(), lightState);
                    break;
                }
                if (!(command instanceof OnOffType)) break;
                StateUpdate lightState = this.lightStateConverter.toColorLightState((OnOffType)command);
                hueBridge.updateLightState(this.getLight(), lightState);
                break;
            }
            default: {
                this.logger.warn("Command send to an unknown channel id: " + channelUID);
            }
        }
    }

    private synchronized HueBridgeHandler getHueBridgeHandler() {
        if (this.bridgeHandler == null) {
            Bridge bridge = this.getBridge();
            if (bridge == null) {
                return null;
            }
            ThingHandler handler = bridge.getHandler();
            if (handler instanceof HueBridgeHandler) {
                this.bridgeHandler = (HueBridgeHandler)handler;
                this.bridgeHandler.registerLightStatusListener(this);
            } else {
                return null;
            }
        }
        return this.bridgeHandler;
    }

    @Override
    public void onLightStateChanged(HueBridge bridge, FullLight fullLight) {
        if (fullLight.getId().equals(this.lightId)) {
            HSBType hsbType = this.lightStateConverter.toHSBType(fullLight.getState());
            this.updateState(new ChannelUID(this.getThing().getUID(), CHANNEL_ID_COLOR), (State)hsbType);
            PercentType percentType = this.lightStateConverter.toColorTemperaturePercentType(fullLight.getState());
            this.updateState(new ChannelUID(this.getThing().getUID(), CHANNEL_ID_COLOR_TEMPERATURE), (State)percentType);
        }
    }

    @Override
    public void onLightRemoved(HueBridge bridge, FullLight light) {
        if (light.getId().equals(this.lightId)) {
            this.getThing().setStatus(ThingStatus.OFFLINE);
        }
    }

    @Override
    public void onLightAdded(HueBridge bridge, FullLight light) {
        if (light.getId().equals(this.lightId)) {
            this.getThing().setStatus(ThingStatus.ONLINE);
        }
    }
}

