/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.handler;

import nl.q42.jue.State;
import nl.q42.jue.StateUpdate;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;

public class LightStateConverter {
    private static final double COLOR_TEMPERATURE_FACTOR = 3.46;
    private static final int COLOR_TEMPERATURE_OFFSET = 154;
    private static final int hue_FACTOR = 182;
    private static final double SATURATION_AND_BRIGHTNESS_FACTOR = 2.54;

    public StateUpdate toColorLightState(HSBType hsbType) {
        int hue = new Long(Math.round(hsbType.getHue().doubleValue() * 182.0)).intValue();
        int saturation = new Long(Math.round(hsbType.getSaturation().doubleValue() * 2.54)).intValue();
        int brightness = new Long(Math.round(hsbType.getBrightness().doubleValue() * 2.54)).intValue();
        StateUpdate stateUpdate = new StateUpdate().setHue(hue).setSat(saturation).setBrightness(brightness);
        return stateUpdate;
    }

    public StateUpdate toColorLightState(OnOffType onOffType) {
        StateUpdate stateUpdate = new StateUpdate().setOn(OnOffType.ON.equals((Object)onOffType));
        return stateUpdate;
    }

    public StateUpdate toColorLightState(PercentType percentType) {
        boolean on = !percentType.equals((Object)PercentType.ZERO);
        int brightness = new Long(Math.round(percentType.doubleValue() * 2.54)).intValue();
        StateUpdate stateUpdate = new StateUpdate().setOn(on).setBrightness(brightness);
        return stateUpdate;
    }

    public StateUpdate toColorTemperatureLightState(PercentType percentType) {
        int colorTemperature = 154 + (int)(3.46 * (double)percentType.intValue());
        StateUpdate stateUpdate = new StateUpdate().setColorTemperature(colorTemperature);
        return stateUpdate;
    }

    public PercentType toColorTemperaturePercentType(State lightState) {
        int percent = (int)((double)(lightState.getColorTemperature() - 154) / 3.46);
        return new PercentType(this.restrictToBounds(percent));
    }

    public HSBType toHSBType(State lightState) {
        int hue = lightState.getHue();
        int saturation = lightState.getSaturation();
        int brightness = lightState.getBrightness();
        int saturationInPercent = (int)((double)saturation / 2.54);
        int brightnessInPercent = (int)((double)brightness / 2.54);
        saturationInPercent = this.restrictToBounds(saturationInPercent);
        brightnessInPercent = this.restrictToBounds(brightnessInPercent);
        HSBType hsbType = new HSBType(new DecimalType((long)(hue / 182)), new PercentType(saturationInPercent), new PercentType(brightnessInPercent));
        return hsbType;
    }

    private int restrictToBounds(int percentValue) {
        if (percentValue < 0) {
            return 0;
        }
        if (percentValue > 100) {
            return 100;
        }
        return percentValue;
    }
}

