/**
 * Copyright (c) 2014 openHAB UG (haftungsbeschraenkt) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.smarthome.binding.yahooweather;

import java.util.Set;

import org.eclipse.smarthome.core.thing.ThingTypeUID;

import com.google.common.collect.ImmutableSet;

/**
 * The {@link YahooWeatherBinding} class defines common constants, which are 
 * used across the whole binding.
 * 
 * @author Kai Kreuzer - Initial contribution
 */
public class YahooWeatherBindingConstants {

    public static final String BINDING_ID = "yahooweather";
    
    // List all Thing Type UIDs, related to the YahooWeather Binding
    public final static ThingTypeUID THING_TYPE_WEATHER = new ThingTypeUID(BINDING_ID, "weather");

    // List all channels
    public static final String CHANNEL_TEMPERATURE = "temperature";
    public static final String CHANNEL_HUMIDITY = "humidity";
    public static final String CHANNEL_PRESSURE = "pressure";

    public final static Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS =ImmutableSet.of(
    		THING_TYPE_WEATHER);
}
