/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.yahooweather.discovery;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.httpclient.URI;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.binding.yahooweather.YahooWeatherBindingConstants;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YahooWeatherDiscoveryService
extends AbstractDiscoveryService {
    private static final Logger logger = LoggerFactory.getLogger(YahooWeatherDiscoveryService.class);

    public YahooWeatherDiscoveryService() {
        super(YahooWeatherBindingConstants.SUPPORTED_THING_TYPES_UIDS, 10);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return YahooWeatherBindingConstants.SUPPORTED_THING_TYPES_UIDS;
    }

    private String downloadData(String urlString) {
        String downloadDataString = null;
        try {
            URL url = new URL(urlString);
            URLConnection connection = url.openConnection();
            downloadDataString = IOUtils.toString((InputStream)connection.getInputStream());
        }
        catch (MalformedURLException e) {
            logger.debug("Constructed url '{}' is not valid: {}", (Object)urlString, (Object)e.getMessage());
        }
        catch (IOException e) {
            logger.error("Error accessing url '{}' : {} ", (Object)urlString, (Object)e.getMessage());
        }
        return downloadDataString;
    }

    private static JsonElement getAtPath(JsonElement e, String path) {
        JsonElement current = e;
        String[] ss = path.split("/");
        int i = 0;
        while (i < ss.length) {
            current = current.getAsJsonObject().get(ss[i]);
            ++i;
        }
        return current;
    }

    private String getWoeidData(String coordinate) {
        String query = "SELECT * FROM geo.placefinder WHERE text='" + coordinate + "' and gflags='R'";
        String url = null;
        try {
            URI uri = new URI("https://query.yahooapis.com/v1/public/yql", false);
            uri.setQuery("q=" + query + "&format=json");
            url = uri.toString();
        }
        catch (Exception e) {
            logger.debug("Error while getting location ID: {}", (Object)e.getMessage());
        }
        return this.downloadData(url);
    }

    private String getGeoFromIpData() {
        String url = "http://freegeoip.net/json/";
        return this.downloadData(url);
    }

    private void discoverLocation() {
        String locationName = null;
        String locationWoeid = null;
        try {
            JsonElement locationData = new JsonParser().parse(this.getGeoFromIpData());
            locationName = String.valueOf(YahooWeatherDiscoveryService.getAtPath(locationData, "city").getAsString()) + ", " + YahooWeatherDiscoveryService.getAtPath(locationData, "country_name").getAsString();
            String locationCoords = String.valueOf(YahooWeatherDiscoveryService.getAtPath(locationData, "latitude").getAsString()) + ", " + YahooWeatherDiscoveryService.getAtPath(locationData, "longitude").getAsString();
            logger.debug("Location from IP: '{}' coordinates: '{}'", (Object)locationName, (Object)locationCoords);
            JsonElement woeidData = new JsonParser().parse(this.getWoeidData(locationCoords));
            locationName = String.valueOf(YahooWeatherDiscoveryService.getAtPath(woeidData, "query/results/Result/city").getAsString()) + ", " + YahooWeatherDiscoveryService.getAtPath(woeidData, "query/results/Result/country").getAsString();
            locationWoeid = YahooWeatherDiscoveryService.getAtPath(woeidData, "query/results/Result/woeid").getAsString();
            logger.debug("Location from locationID: '{}' is: '{}'", (Object)locationWoeid, (Object)locationName);
        }
        catch (Exception e) {
            logger.debug("Error while getting location ID: {}", (Object)e.getMessage());
        }
        if (locationWoeid != null) {
            this.submitDiscoveryResults(locationName, locationWoeid);
        }
    }

    private void submitDiscoveryResults(String locationName, String locationWoeid) {
        ThingUID uid = new ThingUID(YahooWeatherBindingConstants.THING_TYPE_WEATHER, locationWoeid);
        if (uid != null) {
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("location", locationWoeid);
            DiscoveryResult result = DiscoveryResultBuilder.create((ThingUID)uid).withProperties(properties).withLabel("Yahoo weather " + locationName).build();
            this.thingDiscovered(result);
        }
    }

    protected void startBackgroundDiscovery() {
        this.discoverLocation();
    }

    protected void startScan() {
        this.discoverLocation();
    }
}

