/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.yahooweather.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YahooWeatherHandler
extends BaseThingHandler {
    private Logger logger = LoggerFactory.getLogger(YahooWeatherHandler.class);
    private String location;
    private String unit = "c";
    private int refresh = 60;
    private String weatherData = null;
    ScheduledFuture<?> refreshJob;

    public YahooWeatherHandler(Thing thing) {
        super(thing);
    }

    public void initialize() {
        this.logger.debug("Initializing YahooWeather handler.");
        super.initialize();
        Configuration config = this.getThing().getConfiguration();
        this.location = (String)config.get((Object)"location");
        if ("us".equalsIgnoreCase((String)config.get((Object)"unit"))) {
            this.unit = "f";
        }
        try {
            this.refresh = Integer.parseInt((String)config.get((Object)"refresh"));
        }
        catch (Exception exception) {}
        this.startAutomaticRefresh();
    }

    public void dispose() {
        this.refreshJob.cancel(true);
    }

    private void startAutomaticRefresh() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    YahooWeatherHandler.this.updateWeatherData();
                    YahooWeatherHandler.this.updateState(new ChannelUID(YahooWeatherHandler.this.getThing().getUID(), "temperature"), YahooWeatherHandler.this.getTemperature());
                    YahooWeatherHandler.this.updateState(new ChannelUID(YahooWeatherHandler.this.getThing().getUID(), "humidity"), YahooWeatherHandler.this.getHumidity());
                    YahooWeatherHandler.this.updateState(new ChannelUID(YahooWeatherHandler.this.getThing().getUID(), "pressure"), YahooWeatherHandler.this.getPressure());
                }
                catch (Exception e) {
                    YahooWeatherHandler.this.logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        };
        this.refreshJob = this.scheduler.scheduleAtFixedRate(runnable, 0L, this.refresh, TimeUnit.SECONDS);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        block15: {
            block13: {
                if (!(command instanceof RefreshType)) break block13;
                this.updateWeatherData();
                switch (channelUID.getId()) {
                    case "temperature": {
                        this.updateState(channelUID, this.getTemperature());
                        break;
                    }
                    case "humidity": {
                        this.updateState(channelUID, this.getHumidity());
                        break;
                    }
                    case "pressure": {
                        this.updateState(channelUID, this.getPressure());
                        break;
                    }
                    default: {
                        this.logger.debug("Command received for an unknown channel: {}", (Object)channelUID.getId());
                        break;
                    }
                }
                break block15;
            }
            this.logger.debug("Command {} is not supported for channel: {}", (Object)command, (Object)channelUID.getId());
        }
    }

    private synchronized void updateWeatherData() {
        String urlString = "http://weather.yahooapis.com/forecastrss?w=" + this.location + "&u=" + this.unit;
        try {
            URL url = new URL(urlString);
            URLConnection connection = url.openConnection();
            this.weatherData = IOUtils.toString((InputStream)connection.getInputStream());
        }
        catch (MalformedURLException e) {
            this.logger.debug("Constructed url '{}' is not valid: {}", (Object)urlString, (Object)e.getMessage());
        }
        catch (IOException e) {
            this.logger.error("Error accessing Yahoo weather: {}", (Object)e.getMessage());
        }
    }

    private State getHumidity() {
        if (this.weatherData != null) {
            String humidity = StringUtils.substringAfter((String)this.weatherData, (String)"yweather:atmosphere");
            if ((humidity = StringUtils.substringBetween((String)humidity, (String)"humidity=\"", (String)"\"")) != null) {
                return new DecimalType(humidity);
            }
        }
        return UnDefType.UNDEF;
    }

    private State getPressure() {
        if (this.weatherData != null) {
            String pressure = StringUtils.substringAfter((String)this.weatherData, (String)"yweather:atmosphere");
            if ((pressure = StringUtils.substringBetween((String)pressure, (String)"pressure=\"", (String)"\"")) != null) {
                return new DecimalType(pressure);
            }
        }
        return UnDefType.UNDEF;
    }

    private State getTemperature() {
        if (this.weatherData != null) {
            String temp = StringUtils.substringAfter((String)this.weatherData, (String)"yweather:condition");
            if ((temp = StringUtils.substringBetween((String)temp, (String)"temp=\"", (String)"\"")) != null) {
                return new DecimalType(temp);
            }
        }
        return UnDefType.UNDEF;
    }
}

