/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

public class ConfigDescriptionParameter {
    private String name;
    private Type type;
    private String context;
    private boolean required;
    private Object defaultValue;
    private String label;
    private String description;

    public ConfigDescriptionParameter(String name, Type type) throws IllegalArgumentException {
        this(name, type, null, false, null, null, null);
    }

    public ConfigDescriptionParameter(String name, Type type, String context, boolean required, Object defaultValue, String label, String description) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The name must neither be null nor empty!");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null!");
        }
        this.name = name;
        this.type = type;
        this.context = context;
        this.required = required;
        this.defaultValue = defaultValue;
        this.label = label;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getContext() {
        return this.context;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ConfigDescriptionParameter [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", context=" + this.context + ", required=" + this.required + ", defaultValue=" + this.defaultValue + ", label=" + this.label + ", description=" + this.description + "]";
    }

    public static enum Type {
        TEXT,
        INTEGER,
        DECIMAL,
        BOOLEAN;

    }
}

