/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.config.discovery.DiscoveryListener;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.config.discovery.ScanListener;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDiscoveryService
implements DiscoveryService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDiscoveryService.class);
    protected static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(3);
    private Set<DiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<DiscoveryListener>();
    protected ScanListener scanListener = null;
    private boolean backgroundDiscoveryEnabled;
    private Map<ThingUID, DiscoveryResult> cachedResults = new HashMap<ThingUID, DiscoveryResult>();
    private final Set<ThingTypeUID> supportedThingTypes;
    private final int timeout;
    private ScheduledFuture<?> scheduledStop;

    public AbstractDiscoveryService(Set<ThingTypeUID> supportedThingTypes, int timeout, boolean backgroundDiscoveryEnabledByDefault) throws IllegalArgumentException {
        this.supportedThingTypes = supportedThingTypes == null ? Collections.emptySet() : supportedThingTypes;
        if (timeout < 0) {
            throw new IllegalArgumentException("The timeout must be >= 0!");
        }
        this.timeout = timeout;
        this.backgroundDiscoveryEnabled = backgroundDiscoveryEnabledByDefault;
    }

    public AbstractDiscoveryService(Set<ThingTypeUID> supportedThingTypes, int timeout) throws IllegalArgumentException {
        this(supportedThingTypes, timeout, true);
    }

    public AbstractDiscoveryService(int timeout) throws IllegalArgumentException {
        this(null, timeout);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return this.supportedThingTypes;
    }

    @Override
    public int getScanTimeout() {
        return this.timeout;
    }

    @Override
    public void setBackgroundDiscoveryEnabled(boolean enabled) {
        this.backgroundDiscoveryEnabled = enabled;
        if (this.backgroundDiscoveryEnabled) {
            this.startBackgroundDiscovery();
        } else {
            this.stopBackgroundDiscovery();
        }
    }

    @Override
    public boolean isBackgroundDiscoveryEnabled() {
        return this.backgroundDiscoveryEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiscoveryListener(DiscoveryListener listener) {
        Map<ThingUID, DiscoveryResult> map = this.cachedResults;
        synchronized (map) {
            for (DiscoveryResult cachedResult : this.cachedResults.values()) {
                listener.thingDiscovered(this, cachedResult);
            }
        }
        this.discoveryListeners.add(listener);
    }

    @Override
    public void removeDiscoveryListener(DiscoveryListener listener) {
        this.discoveryListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startScan(ScanListener listener) {
        AbstractDiscoveryService abstractDiscoveryService = this;
        synchronized (abstractDiscoveryService) {
            this.stopScan();
            if (this.scheduledStop != null) {
                this.scheduledStop.cancel(false);
                this.scheduledStop = null;
            }
            this.scanListener = listener;
            if (this.getScanTimeout() > 0) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractDiscoveryService.this.stopScan();
                        }
                        catch (Exception e) {
                            logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                };
                this.scheduledStop = scheduler.schedule(runnable, (long)this.getScanTimeout(), TimeUnit.SECONDS);
            }
            try {
                this.startScan();
            }
            catch (Exception ex) {
                if (this.scheduledStop != null) {
                    this.scheduledStop.cancel(false);
                    this.scheduledStop = null;
                }
                this.scanListener = null;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void abortScan() {
        AbstractDiscoveryService abstractDiscoveryService = this;
        synchronized (abstractDiscoveryService) {
            if (this.scheduledStop != null) {
                this.scheduledStop.cancel(false);
                this.scheduledStop = null;
            }
            if (this.scanListener != null) {
                CancellationException e = new CancellationException("Scan has been aborted.");
                this.scanListener.onErrorOccurred(e);
                this.scanListener = null;
            }
        }
    }

    protected abstract void startScan();

    protected synchronized void stopScan() {
        if (this.scanListener != null) {
            this.scanListener.onFinished();
            this.scanListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void thingDiscovered(DiscoveryResult discoveryResult) {
        for (DiscoveryListener discoveryListener : this.discoveryListeners) {
            try {
                discoveryListener.thingDiscovered(this, discoveryResult);
            }
            catch (Exception e) {
                logger.error("An error occurred while calling the discovery listener " + discoveryListener.getClass().getName() + ".", (Throwable)e);
            }
        }
        Map<ThingUID, DiscoveryResult> map = this.cachedResults;
        synchronized (map) {
            this.cachedResults.put(discoveryResult.getThingUID(), discoveryResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void thingRemoved(ThingUID thingUID) {
        for (DiscoveryListener discoveryListener : this.discoveryListeners) {
            try {
                discoveryListener.thingRemoved(this, thingUID);
            }
            catch (Exception e) {
                logger.error("An error occurred while calling the discovery listener " + discoveryListener.getClass().getName() + ".", (Throwable)e);
            }
        }
        Map<ThingUID, DiscoveryResult> map = this.cachedResults;
        synchronized (map) {
            this.cachedResults.remove(thingUID);
        }
    }

    protected void activate() {
        if (this.backgroundDiscoveryEnabled) {
            this.startBackgroundDiscovery();
        }
    }

    protected void deactivate() {
        if (this.backgroundDiscoveryEnabled) {
            this.stopBackgroundDiscovery();
        }
    }

    protected void startBackgroundDiscovery() {
    }

    protected void stopBackgroundDiscovery() {
    }
}

