/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultFlag;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;

public class DiscoveryResultImpl
implements DiscoveryResult {
    private ThingUID bridgeUID;
    private ThingUID thingUID;
    private Map<String, Object> properties;
    private DiscoveryResultFlag flag;
    private String label;

    DiscoveryResultImpl() {
    }

    public DiscoveryResultImpl(ThingUID thingUID, ThingUID bridgeUID, Map<String, Object> properties, String label) throws IllegalArgumentException {
        if (thingUID == null) {
            throw new IllegalArgumentException("The thing UID must not be null!");
        }
        this.thingUID = thingUID;
        this.bridgeUID = bridgeUID;
        this.properties = Collections.unmodifiableMap(properties != null ? new HashMap<String, Object>(properties) : new HashMap());
        this.label = label == null ? "" : label;
        this.flag = DiscoveryResultFlag.NEW;
    }

    @Override
    public ThingUID getThingUID() {
        return this.thingUID;
    }

    @Override
    public ThingTypeUID getThingTypeUID() {
        return this.thingUID.getThingTypeUID();
    }

    @Override
    public String getBindingId() {
        ThingUID thingId = this.thingUID;
        if (thingId != null) {
            return thingId.getBindingId();
        }
        return null;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public DiscoveryResultFlag getFlag() {
        return this.flag;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public ThingUID getBridgeUID() {
        return this.bridgeUID;
    }

    public void synchronize(DiscoveryResult sourceResult) {
        if (sourceResult != null && sourceResult.getThingUID().equals((Object)this.thingUID)) {
            this.properties = sourceResult.getProperties();
            this.label = sourceResult.getLabel();
        }
    }

    public void setFlag(DiscoveryResultFlag flag) {
        this.flag = flag == null ? DiscoveryResultFlag.NEW : flag;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.thingUID == null ? 0 : this.thingUID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscoveryResultImpl other = (DiscoveryResultImpl)obj;
        return !(this.thingUID == null ? other.thingUID != null : !this.thingUID.equals((Object)other.thingUID));
    }

    public String toString() {
        return "DiscoveryResult [thingUID=" + this.thingUID + ", properties=" + this.properties + ", flag=" + (Object)((Object)this.flag) + ", label=" + this.label + ", bridgeUID=" + this.bridgeUID + "]";
    }
}

