/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.config.discovery.DiscoveryListener;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryServiceRegistry;
import org.eclipse.smarthome.config.discovery.ScanListener;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiscoveryServiceRegistryImpl
implements DiscoveryServiceRegistry,
DiscoveryListener {
    private List<DiscoveryService> discoveryServices = new CopyOnWriteArrayList<DiscoveryService>();
    private Set<DiscoveryListener> listeners = new CopyOnWriteArraySet<DiscoveryListener>();
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryServiceRegistryImpl.class);

    @Override
    public boolean abortScan(ThingTypeUID thingTypeUID) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForThingType = this.getDiscoveryServices(thingTypeUID);
        if (discoveryServicesForThingType.isEmpty()) {
            logger.warn("No discovery service for thing type '{}' found!", (Object)thingTypeUID);
            return false;
        }
        return this.abortScans(discoveryServicesForThingType);
    }

    @Override
    public boolean abortScan(String bindingId) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForBinding = this.getDiscoveryServices(bindingId);
        if (discoveryServicesForBinding.isEmpty()) {
            logger.warn("No discovery service for binding '{}' found!", (Object)bindingId);
            return false;
        }
        return this.abortScans(discoveryServicesForBinding);
    }

    @Override
    public void addDiscoveryListener(DiscoveryListener listener) throws IllegalStateException {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean startScan(ThingTypeUID thingTypeUID, ScanListener listener) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForThingType = this.getDiscoveryServices(thingTypeUID);
        if (discoveryServicesForThingType.isEmpty()) {
            logger.warn("No discovery service for thing type '{}' found!", (Object)thingTypeUID);
            return false;
        }
        return this.startScans(discoveryServicesForThingType, listener);
    }

    @Override
    public boolean startScan(String bindingId, ScanListener listener) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForBinding = this.getDiscoveryServices(bindingId);
        if (discoveryServicesForBinding.isEmpty()) {
            logger.warn("No discovery service for binding id '{}' found!", (Object)bindingId);
            return false;
        }
        return this.startScans(discoveryServicesForBinding, listener);
    }

    @Override
    public boolean supportsDiscovery(ThingTypeUID thingTypeUID) {
        return !this.getDiscoveryServices(thingTypeUID).isEmpty();
    }

    @Override
    public boolean supportsDiscovery(String bindingId) {
        return !this.getDiscoveryServices(bindingId).isEmpty();
    }

    @Override
    public synchronized void removeDiscoveryListener(DiscoveryListener listener) throws IllegalStateException {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public synchronized void thingDiscovered(DiscoveryService source, DiscoveryResult result) {
        for (DiscoveryListener listener : this.listeners) {
            try {
                listener.thingDiscovered(source, result);
            }
            catch (Exception ex) {
                logger.error("Cannot notify the DiscoveryListener " + listener.getClass().getName() + " on Thing discovered event!", (Throwable)ex);
            }
        }
    }

    @Override
    public synchronized void thingRemoved(DiscoveryService source, ThingUID thingUID) {
        for (DiscoveryListener listener : this.listeners) {
            try {
                listener.thingRemoved(source, thingUID);
            }
            catch (Exception ex) {
                logger.error("Cannot notify the DiscoveryListener '" + listener.getClass().getName() + "' on Thing removed event!", (Throwable)ex);
            }
        }
    }

    private boolean abortScans(Set<DiscoveryService> discoveryServices) {
        boolean allServicesAborted = true;
        for (DiscoveryService discoveryService : discoveryServices) {
            Collection<ThingTypeUID> supportedThingTypes = discoveryService.getSupportedThingTypes();
            try {
                logger.debug("Abort scan for thing types '{}' on '{}'...", supportedThingTypes, (Object)discoveryService.getClass().getName());
                discoveryService.abortScan();
                logger.debug("Scan for thing types '{}' aborted on '{}'.", supportedThingTypes, (Object)discoveryService.getClass().getName());
            }
            catch (Exception ex) {
                logger.error("Cannot abort scan for thing types '" + supportedThingTypes + "' on '" + discoveryService.getClass().getName() + "'!", (Throwable)ex);
                allServicesAborted = false;
            }
        }
        return allServicesAborted;
    }

    private boolean startScans(Set<DiscoveryService> discoveryServices, ScanListener listener) {
        boolean atLeastOneDiscoveryServiceHasBeenStarted = false;
        if (discoveryServices.size() > 1) {
            logger.debug("Trying to start {} scans with an aggregating listener.", (Object)discoveryServices.size());
            AggregatingScanListener aggregatingScanListener = new AggregatingScanListener(discoveryServices.size(), listener);
            for (DiscoveryService discoveryService : discoveryServices) {
                if (this.startScan(discoveryService, (ScanListener)aggregatingScanListener)) {
                    atLeastOneDiscoveryServiceHasBeenStarted = true;
                    continue;
                }
                logger.debug("Reducing number of discovery services in aggregating listener, because discovery service failed to start scan.");
                aggregatingScanListener.reduceNumberOfDiscoveryServices();
            }
        } else if (this.startScan(discoveryServices.iterator().next(), listener)) {
            atLeastOneDiscoveryServiceHasBeenStarted = true;
        }
        return atLeastOneDiscoveryServiceHasBeenStarted;
    }

    private boolean startScan(DiscoveryService discoveryService, ScanListener listener) {
        Collection<ThingTypeUID> supportedThingTypes = discoveryService.getSupportedThingTypes();
        try {
            logger.debug("Triggering scan for thing types '{}' on '{}'...", supportedThingTypes, (Object)discoveryService.getClass().getSimpleName());
            discoveryService.startScan(listener);
            return true;
        }
        catch (Exception ex) {
            logger.error("Cannot trigger scan for thing types '" + supportedThingTypes + "' on '" + discoveryService.getClass().getSimpleName() + "'!", (Throwable)ex);
            return false;
        }
    }

    private synchronized Set<DiscoveryService> getDiscoveryServices(ThingTypeUID thingTypeUID) throws IllegalStateException {
        HashSet<DiscoveryService> discoveryServices = new HashSet<DiscoveryService>();
        if (thingTypeUID != null) {
            for (DiscoveryService discoveryService : this.discoveryServices) {
                Collection<ThingTypeUID> discoveryThingTypes = discoveryService.getSupportedThingTypes();
                if (!discoveryThingTypes.contains(thingTypeUID)) continue;
                discoveryServices.add(discoveryService);
            }
        }
        return discoveryServices;
    }

    private synchronized Set<DiscoveryService> getDiscoveryServices(String bindingId) throws IllegalStateException {
        HashSet<DiscoveryService> discoveryServices = new HashSet<DiscoveryService>();
        for (DiscoveryService discoveryService : this.discoveryServices) {
            Collection<ThingTypeUID> discoveryThingTypes = discoveryService.getSupportedThingTypes();
            for (ThingTypeUID thingTypeUID : discoveryThingTypes) {
                if (!thingTypeUID.getBindingId().equals(bindingId)) continue;
                discoveryServices.add(discoveryService);
            }
        }
        return discoveryServices;
    }

    protected void addDiscoveryService(DiscoveryService discoveryService) {
        discoveryService.addDiscoveryListener(this);
        this.discoveryServices.add(discoveryService);
    }

    protected void removeDiscoveryService(DiscoveryService discoveryService) {
        this.discoveryServices.remove(discoveryService);
        discoveryService.removeDiscoveryListener(this);
    }

    protected void deactivate() {
        this.discoveryServices.clear();
        this.listeners.clear();
    }

    private final class AggregatingScanListener
    implements ScanListener {
        private final ScanListener listener;
        private int finishedDiscoveryServices = 0;
        private boolean errorOccured = false;
        private int numberOfDiscoveryServices;

        private AggregatingScanListener(int numberOfDiscoveryServices, ScanListener listener) {
            this.numberOfDiscoveryServices = numberOfDiscoveryServices;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void onFinished() {
            AggregatingScanListener aggregatingScanListener = this;
            synchronized (aggregatingScanListener) {
                ++this.finishedDiscoveryServices;
                logger.debug("Finished {} of {} discovery services.", (Object)this.finishedDiscoveryServices, (Object)this.numberOfDiscoveryServices);
                if (!this.errorOccured && this.finishedDiscoveryServices == this.numberOfDiscoveryServices && this.listener != null) {
                    this.listener.onFinished();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onErrorOccurred(Exception exception) {
            AggregatingScanListener aggregatingScanListener = this;
            synchronized (aggregatingScanListener) {
                if (!this.errorOccured) {
                    if (this.listener != null) {
                        this.listener.onErrorOccurred(exception);
                    }
                    this.errorOccured = true;
                } else {
                    logger.warn("Error occured while executing discovery service: " + exception.getMessage(), (Throwable)exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reduceNumberOfDiscoveryServices() {
            AggregatingScanListener aggregatingScanListener = this;
            synchronized (aggregatingScanListener) {
                --this.numberOfDiscoveryServices;
                if (!this.errorOccured && this.finishedDiscoveryServices == this.numberOfDiscoveryServices && this.listener != null) {
                    this.listener.onFinished();
                }
            }
        }
    }
}

