/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.discovery.DiscoveryListener;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultFlag;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryServiceRegistry;
import org.eclipse.smarthome.config.discovery.inbox.Inbox;
import org.eclipse.smarthome.config.discovery.inbox.InboxFilterCriteria;
import org.eclipse.smarthome.config.discovery.inbox.InboxListener;
import org.eclipse.smarthome.config.discovery.internal.DiscoveryResultImpl;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.storage.Storage;
import org.eclipse.smarthome.core.storage.StorageService;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingRegistryChangeListener;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistentInbox
implements Inbox,
DiscoveryListener,
ThingRegistryChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(PersistentInbox.class);
    private Set<InboxListener> listeners = new CopyOnWriteArraySet<InboxListener>();
    private DiscoveryServiceRegistry discoveryServiceRegistry;
    private ThingRegistry thingRegistry;
    private ManagedThingProvider managedThingProvider;
    private Storage<DiscoveryResult> discoveryResultStorage;

    @Override
    public synchronized boolean add(DiscoveryResult result) throws IllegalStateException {
        if (result != null) {
            ThingUID thingUID = result.getThingUID();
            Thing thing = this.thingRegistry.getByUID(thingUID);
            if (thing == null) {
                DiscoveryResult inboxResult = this.get(thingUID);
                if (inboxResult == null) {
                    this.discoveryResultStorage.put(result.getThingUID().toString(), (Object)result);
                    this.notifyListeners(result, EventType.added);
                    logger.info("Added new thing '{}' to inbox.", (Object)thingUID);
                    return true;
                }
                if (inboxResult instanceof DiscoveryResultImpl) {
                    DiscoveryResultImpl resultImpl = (DiscoveryResultImpl)inboxResult;
                    resultImpl.synchronize(result);
                    this.discoveryResultStorage.put(result.getThingUID().toString(), (Object)resultImpl);
                    this.notifyListeners(resultImpl, EventType.updated);
                    logger.debug("Updated discovery result for '{}'.", (Object)thingUID);
                    return true;
                }
                logger.warn("Cannot synchronize result with implementation class '{}'.", (Object)inboxResult.getClass().getName());
            } else {
                logger.debug("Discovery result with thing '{}' not added as inbox entry. It is already present as thing in the ThingRegistry.", (Object)thingUID);
                boolean updated = this.synchronizeConfiguration(result.getProperties(), thing.getConfiguration());
                if (updated) {
                    logger.debug("The configuration for thing '{}' is updated...", (Object)thingUID);
                    this.managedThingProvider.update((Object)thing);
                }
            }
        }
        return false;
    }

    private boolean synchronizeConfiguration(Map<String, Object> properties, Configuration config) {
        boolean configUpdated = false;
        Set<Map.Entry<String, Object>> propertySet = properties.entrySet();
        for (Map.Entry<String, Object> propertyEntry : propertySet) {
            String propertyKey = propertyEntry.getKey();
            Object propertyValue = propertyEntry.getValue();
            Object configValue = config.get((Object)propertyKey);
            if ((propertyValue != null || configValue == null) && (propertyValue == null || propertyValue.equals(configValue))) continue;
            config.put(propertyKey, propertyValue);
            configUpdated = true;
        }
        return configUpdated;
    }

    @Override
    public void addInboxListener(InboxListener listener) throws IllegalStateException {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public List<DiscoveryResult> get(InboxFilterCriteria criteria) throws IllegalStateException {
        ArrayList<DiscoveryResult> filteredEntries = new ArrayList<DiscoveryResult>();
        for (DiscoveryResult discoveryResult : this.discoveryResultStorage.getValues()) {
            if (!this.matchFilter(discoveryResult, criteria)) continue;
            filteredEntries.add(discoveryResult);
        }
        return filteredEntries;
    }

    @Override
    public List<DiscoveryResult> getAll() {
        return this.get((InboxFilterCriteria)null);
    }

    @Override
    public synchronized boolean remove(ThingUID thingUID) throws IllegalStateException {
        DiscoveryResult discoveryResult;
        if (thingUID != null && (discoveryResult = this.get(thingUID)) != null) {
            this.discoveryResultStorage.remove(thingUID.toString());
            this.notifyListeners(discoveryResult, EventType.removed);
            return true;
        }
        return false;
    }

    @Override
    public void removeInboxListener(InboxListener listener) throws IllegalStateException {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void thingDiscovered(DiscoveryService source, DiscoveryResult result) {
        this.add(result);
    }

    @Override
    public void thingRemoved(DiscoveryService source, ThingUID thingUID) {
        this.remove(thingUID);
    }

    public void added(Thing thing) {
        if (this.remove(thing.getUID())) {
            logger.debug("Discovery result removed from inbox, because it was added as a Thing to the ThingRegistry.");
        }
    }

    public void removed(Thing thing) {
    }

    public void updated(Thing oldThing, Thing thing) {
    }

    @Override
    public void setFlag(ThingUID thingUID, DiscoveryResultFlag flag) {
        DiscoveryResult result = this.get(thingUID);
        if (result instanceof DiscoveryResultImpl) {
            DiscoveryResultImpl resultImpl = (DiscoveryResultImpl)result;
            resultImpl.setFlag(flag == null ? DiscoveryResultFlag.NEW : flag);
            this.discoveryResultStorage.put(resultImpl.getThingUID().toString(), (Object)resultImpl);
            this.notifyListeners(resultImpl, EventType.updated);
        } else {
            logger.warn("Cannot set flag for result of instance type '{}'", (Object)result.getClass().getName());
        }
    }

    private DiscoveryResult get(ThingUID thingUID) {
        if (thingUID != null) {
            return (DiscoveryResult)this.discoveryResultStorage.get(thingUID.toString());
        }
        return null;
    }

    private boolean matchFilter(DiscoveryResult discoveryResult, InboxFilterCriteria criteria) {
        if (criteria != null) {
            String bindingId = criteria.getBindingId();
            if (bindingId != null && !bindingId.isEmpty() && !discoveryResult.getBindingId().equals(bindingId)) {
                return false;
            }
            ThingTypeUID thingTypeUID = criteria.getThingTypeUID();
            if (thingTypeUID != null && !discoveryResult.getThingTypeUID().equals((Object)thingTypeUID)) {
                return false;
            }
            ThingUID thingUID = criteria.getThingUID();
            if (thingUID != null && !discoveryResult.getThingUID().equals((Object)thingUID)) {
                return false;
            }
            DiscoveryResultFlag flag = criteria.getFlag();
            if (flag != null && discoveryResult.getFlag() != flag) {
                return false;
            }
        }
        return true;
    }

    private void notifyListeners(DiscoveryResult result, EventType type) {
        for (InboxListener listener : this.listeners) {
            try {
                switch (type) {
                    case added: {
                        listener.thingAdded(this, result);
                        break;
                    }
                    case removed: {
                        listener.thingRemoved(this, result);
                        break;
                    }
                    case updated: {
                        listener.thingUpdated(this, result);
                    }
                }
            }
            catch (Exception ex) {
                String errorMessage = String.format("Cannot notify the InboxListener '%s' about a Thing %s event!", listener.getClass().getName(), type.name());
                logger.error(errorMessage, (Throwable)ex);
            }
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.listeners.clear();
    }

    protected void setDiscoveryServiceRegistry(DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry = discoveryServiceRegistry;
        this.discoveryServiceRegistry.addDiscoveryListener(this);
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
        this.thingRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    protected void setManagedThingProvider(ManagedThingProvider thingProvider) {
        this.managedThingProvider = thingProvider;
    }

    protected void unsetDiscoveryServiceRegistry(DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry.removeDiscoveryListener(this);
        this.discoveryServiceRegistry = null;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.thingRegistry = null;
    }

    protected void unsetManagedThingProvider(ManagedThingProvider thingProvider) {
        this.managedThingProvider = null;
    }

    protected void setStorageService(StorageService storageService) {
        this.discoveryResultStorage = storageService.getStorage(DiscoveryResult.class.getName(), this.getClass().getClassLoader());
    }

    protected void unsetStorageService(StorageService storageService) {
        this.discoveryResultStorage = null;
    }

    private static enum EventType {
        added,
        removed,
        updated;

    }
}

