/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal.console;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.config.discovery.DiscoveryServiceRegistry;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;

public class DiscoveryConsoleCommandExtension
implements ConsoleCommandExtension {
    private DiscoveryServiceRegistry discoveryServiceRegistry;
    private static final String COMMAND_DISCOVERY = "discovery";
    private static final List<String> SUPPORTED_COMMANDS = Lists.newArrayList((Object[])new String[]{"discovery"});

    public boolean canHandle(String[] args) {
        String firstArgument = args[0];
        return SUPPORTED_COMMANDS.contains(firstArgument);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void execute(String[] args, Console console) {
        String command;
        switch (command = args[0]) {
            case "discovery": {
                String subCommand;
                if (args.length <= 1) {
                    console.println(this.getUsages().get(0));
                    return;
                }
                switch (subCommand = args[1]) {
                    case "start": {
                        if (args.length <= 2) {
                            console.println("Specify thing type id or binding id to discover: discovery start <thingTypeUID|bindingID> (e.g. \"hue:bridge\" or \"hue\")");
                            return;
                        }
                        String arg2 = args[2];
                        if (arg2.contains(":")) {
                            ThingTypeUID thingTypeUID = new ThingTypeUID(arg2);
                            this.runDiscoveryForThingType(console, thingTypeUID);
                            return;
                        }
                        this.runDiscoveryForBinding(console, arg2);
                        return;
                    }
                }
                return;
            }
        }
    }

    private void runDiscoveryForThingType(Console console, ThingTypeUID thingTypeUID) {
        this.discoveryServiceRegistry.startScan(thingTypeUID, null);
    }

    private void runDiscoveryForBinding(Console console, String bindingId) {
        this.discoveryServiceRegistry.startScan(bindingId, null);
    }

    public List<String> getUsages() {
        return Collections.singletonList("discovery start <thingTypeUID|bindingID> - runs a discovery on a given thing type or binding");
    }

    protected void setDiscoveryServiceRegistry(DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry = discoveryServiceRegistry;
    }

    protected void unsetDiscoveryServiceRegistry(DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry = null;
    }
}

