/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal.console;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultFlag;
import org.eclipse.smarthome.config.discovery.inbox.Inbox;
import org.eclipse.smarthome.config.discovery.inbox.InboxFilterCriteria;
import org.eclipse.smarthome.config.discovery.internal.PersistentInbox;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;

public class InboxConsoleCommandExtension
implements ConsoleCommandExtension {
    private static final String COMMAND_INBOX = "inbox";
    private static final List<String> SUPPORTED_COMMANDS = Lists.newArrayList((Object[])new String[]{"inbox"});
    private Inbox inbox;
    private ManagedThingProvider managedThingProvider;

    public boolean canHandle(String[] args) {
        String firstArgument = args[0];
        return SUPPORTED_COMMANDS.contains(firstArgument);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(String[] args, Console console) {
        String command;
        switch (command = args[0]) {
            case "inbox": {
                if (args.length > 1) {
                    String subCommand;
                    switch (subCommand = args[1]) {
                        case "approve": {
                            if (args.length <= 2) {
                                console.println("Specify thing id to approve: inbox approve <thingUID>");
                                return;
                            }
                            if (this.managedThingProvider == null) {
                                console.println("Cannot approve thing as managed thing provider is missing.");
                                return;
                            }
                            try {
                                ThingUID thingUID = new ThingUID(args[2]);
                                List<DiscoveryResult> results = this.inbox.get(new InboxFilterCriteria(thingUID, null));
                                if (results.isEmpty()) {
                                    console.println("No matching inbox entry could be found.");
                                    return;
                                }
                                DiscoveryResult result = results.get(0);
                                Configuration conf = new Configuration(result.getProperties());
                                this.managedThingProvider.createThing(result.getThingTypeUID(), result.getThingUID(), result.getBridgeUID(), conf);
                                return;
                            }
                            catch (Exception e) {
                                console.println(e.getMessage());
                                return;
                            }
                        }
                        case "ignore": {
                            if (args.length <= 2) {
                                console.println("Cannot approve thing as managed thing provider is missing.");
                                return;
                            }
                            try {
                                ThingUID thingUID = new ThingUID(args[2]);
                                PersistentInbox persistentInbox = (PersistentInbox)this.inbox;
                                persistentInbox.setFlag(thingUID, DiscoveryResultFlag.IGNORED);
                                return;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                console.println("'" + args[2] + "' is no valid thing UID.");
                                return;
                            }
                        }
                        case "listignored": {
                            this.printInboxEntries(console, this.inbox.get(new InboxFilterCriteria(DiscoveryResultFlag.IGNORED)));
                            return;
                        }
                        case "clear": {
                            this.clearInboxEntries(console, this.inbox.get(new InboxFilterCriteria(DiscoveryResultFlag.NEW)));
                            return;
                        }
                    }
                }
                this.printInboxEntries(console, this.inbox.get(new InboxFilterCriteria(DiscoveryResultFlag.NEW)));
                return;
            }
        }
    }

    private void printInboxEntries(Console console, List<DiscoveryResult> discoveryResults) {
        if (discoveryResults.isEmpty()) {
            console.println("No inbox entries found.");
        }
        for (DiscoveryResult discoveryResult : discoveryResults) {
            ThingTypeUID thingTypeUID = discoveryResult.getThingTypeUID();
            ThingUID thingUID = discoveryResult.getThingUID();
            String label = discoveryResult.getLabel();
            DiscoveryResultFlag flag = discoveryResult.getFlag();
            ThingUID bridgeId = discoveryResult.getBridgeUID();
            Map<String, Object> properties = discoveryResult.getProperties();
            console.println(String.format("%s [%s]: %s [thingId=%s, bridgeId=%s, properties=%s]", flag.name(), thingTypeUID, label, thingUID, bridgeId, properties));
        }
    }

    private void clearInboxEntries(Console console, List<DiscoveryResult> discoveryResults) {
        if (discoveryResults.isEmpty()) {
            console.println("No inbox entries found.");
        }
        for (DiscoveryResult discoveryResult : discoveryResults) {
            ThingTypeUID thingTypeUID = discoveryResult.getThingTypeUID();
            ThingUID thingUID = discoveryResult.getThingUID();
            String label = discoveryResult.getLabel();
            DiscoveryResultFlag flag = discoveryResult.getFlag();
            ThingUID bridgeId = discoveryResult.getBridgeUID();
            Map<String, Object> properties = discoveryResult.getProperties();
            console.println(String.format("REMOVED [%s]: %s [thingId=%s, bridgeId=%s, properties=%s]", flag.name(), thingTypeUID, label, thingUID, bridgeId, properties));
            this.inbox.remove(thingUID);
        }
    }

    public List<String> getUsages() {
        return Arrays.asList("inbox - lists all current inbox entries", "inbox listignored - lists all ignored inbox entries", "inbox approve <thingUID> - creates a thing for an inbox entry", "inbox clear - clears all current inbox entries", "inbox ignore <thingUID> - ignores an inbox entry permanently");
    }

    protected void setInbox(Inbox inbox) {
        this.inbox = inbox;
    }

    protected void unsetInbox(Inbox inbox) {
        this.inbox = null;
    }

    protected void setManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = managedThingProvider;
    }

    protected void unsetManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = null;
    }
}

