/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.xml.util.ConverterAssertion;
import org.eclipse.smarthome.config.xml.util.ConverterAttributeMapValidator;
import org.eclipse.smarthome.config.xml.util.GenericUnmarshaller;

public class ConfigDescriptionConverter
extends GenericUnmarshaller<ConfigDescription> {
    private ConverterAttributeMapValidator attributeMapValidator = new ConverterAttributeMapValidator(new String[][]{{"uri", "false"}});

    public ConfigDescriptionConverter() {
        super(ConfigDescription.class);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ConfigDescription configDescription = null;
        Map<String, String> attributes = this.attributeMapValidator.readValidatedAttributes(reader);
        String uriText = attributes.get("uri");
        if (uriText == null) {
            uriText = (String)context.get((Object)"config-description.uri");
        }
        URI uri = null;
        try {
            uri = new URI(uriText);
        }
        catch (NullPointerException | URISyntaxException ex) {
            throw new ConversionException("The URI '" + uriText + "' in node '" + reader.getNodeName() + "' is invalid!", (Throwable)ex);
        }
        List configDescriptionParams = (List)context.convertAnother((Object)context, List.class);
        ConverterAssertion.assertEndOfType(reader);
        configDescription = new ConfigDescription(uri, configDescriptionParams);
        return configDescription;
    }
}

