/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionProvider;
import org.eclipse.smarthome.config.core.ConfigDescriptionsChangeListener;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConfigDescriptionProvider
implements ConfigDescriptionProvider {
    private Logger logger = LoggerFactory.getLogger(XmlConfigDescriptionProvider.class);
    private Map<Bundle, List<ConfigDescription>> bundleConfigDescriptionsMap = new HashMap<Bundle, List<ConfigDescription>>(10);
    private List<ConfigDescriptionsChangeListener> configDescriptionListeners = new CopyOnWriteArrayList<ConfigDescriptionsChangeListener>();

    private List<ConfigDescription> acquireConfigDescriptions(Bundle bundle) {
        if (bundle != null) {
            List<ConfigDescription> configDescriptions = this.bundleConfigDescriptionsMap.get(bundle);
            if (configDescriptions == null) {
                configDescriptions = new ArrayList<ConfigDescription>(10);
                this.bundleConfigDescriptionsMap.put(bundle, configDescriptions);
            }
            return configDescriptions;
        }
        return null;
    }

    public synchronized void addConfigDescription(Bundle bundle, ConfigDescription configDescription) {
        List<ConfigDescription> configDescriptionList;
        if (configDescription != null && (configDescriptionList = this.acquireConfigDescriptions(bundle)) != null) {
            this.sendConfigDescriptionEvent(configDescription, true);
            configDescriptionList.add(configDescription);
        }
    }

    public synchronized void addConfigDescriptions(Bundle bundle, List<ConfigDescription> configDescriptions) {
        List<ConfigDescription> currentConfigDescriptionList;
        if (configDescriptions != null && configDescriptions.size() > 0 && (currentConfigDescriptionList = this.acquireConfigDescriptions(bundle)) != null) {
            for (ConfigDescription configDescription : configDescriptions) {
                this.sendConfigDescriptionEvent(configDescription, true);
                currentConfigDescriptionList.add(configDescription);
            }
        }
    }

    public synchronized void removeAllConfigDescriptions(Bundle bundle) {
        List<ConfigDescription> configDescriptions;
        if (bundle != null && (configDescriptions = this.bundleConfigDescriptionsMap.get(bundle)) != null) {
            for (ConfigDescription configDescription : configDescriptions) {
                this.sendConfigDescriptionEvent(configDescription, false);
            }
            this.bundleConfigDescriptionsMap.remove(bundle);
        }
    }

    public synchronized void addConfigDescriptionsChangeListener(ConfigDescriptionsChangeListener listener) {
        if (listener != null && !this.configDescriptionListeners.contains(listener)) {
            this.configDescriptionListeners.add(listener);
        }
    }

    public synchronized void removeConfigDescriptionsChangeListener(ConfigDescriptionsChangeListener listener) {
        if (listener != null) {
            this.configDescriptionListeners.remove(listener);
        }
    }

    public synchronized Collection<ConfigDescription> getConfigDescriptions() {
        ArrayList<ConfigDescription> allConfigDescriptions = new ArrayList<ConfigDescription>();
        Collection<List<ConfigDescription>> configDescriptions = this.bundleConfigDescriptionsMap.values();
        if (configDescriptions != null) {
            for (List<ConfigDescription> configDescription : configDescriptions) {
                allConfigDescriptions.addAll(configDescription);
            }
        }
        return allConfigDescriptions;
    }

    private void sendConfigDescriptionEvent(ConfigDescription configDescription, boolean added) {
        for (ConfigDescriptionsChangeListener listener : this.configDescriptionListeners) {
            try {
                if (added) {
                    listener.configDescriptionAdded((ConfigDescriptionProvider)this, configDescription);
                    continue;
                }
                listener.configDescriptionRemoved((ConfigDescriptionProvider)this, configDescription);
            }
            catch (Exception ex) {
                this.logger.error("Could not send an " + (added ? "added" : "removed") + " ConfigDescription event to the listener '" + listener + "'!", (Throwable)ex);
            }
        }
    }
}

