/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml.osgi;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProviderFactory;
import org.eclipse.smarthome.config.xml.util.XmlDocumentReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDocumentBundleTracker<T>
extends BundleTracker<Bundle> {
    private Logger logger = LoggerFactory.getLogger(XmlDocumentBundleTracker.class);
    private String xmlDirectory;
    private XmlDocumentReader<T> xmlDocumentTypeReader;
    private XmlDocumentProviderFactory<T> xmlDocumentProviderFactory;
    private Map<Bundle, XmlDocumentProvider<T>> bundleDocumentProviderMap;

    public XmlDocumentBundleTracker(BundleContext bundleContext, String xmlDirectory, XmlDocumentReader<T> xmlDocumentTypeReader, XmlDocumentProviderFactory<T> xmlDocumentProviderFactory) throws IllegalArgumentException {
        super(bundleContext, 32, null);
        if (bundleContext == null) {
            throw new IllegalArgumentException("The BundleContext must not be null!");
        }
        if (xmlDirectory == null || xmlDirectory.isEmpty()) {
            throw new IllegalArgumentException("The XML directory must neither be null, nor empty!");
        }
        if (xmlDocumentTypeReader == null) {
            throw new IllegalArgumentException("The XmlDocumentTypeReader must not be null!");
        }
        if (xmlDocumentProviderFactory == null) {
            throw new IllegalArgumentException("The XmlDocumentProviderFactory must not be null!");
        }
        this.xmlDirectory = xmlDirectory;
        this.xmlDocumentTypeReader = xmlDocumentTypeReader;
        this.xmlDocumentProviderFactory = xmlDocumentProviderFactory;
        this.bundleDocumentProviderMap = new HashMap<Bundle, XmlDocumentProvider<T>>();
    }

    public final synchronized void open() {
        super.open();
    }

    public final synchronized void close() {
        super.close();
        this.bundleDocumentProviderMap.clear();
    }

    private XmlDocumentProvider<T> acquireXmlDocumentProvider(Bundle bundle) {
        if (bundle != null) {
            XmlDocumentProvider<T> xmlDocumentProvider = this.bundleDocumentProviderMap.get(bundle);
            if (xmlDocumentProvider == null) {
                xmlDocumentProvider = this.xmlDocumentProviderFactory.createDocumentProvider(bundle);
                this.logger.debug("Create an empty XmlDocumentProvider for the module '{}'.", (Object)bundle.getSymbolicName());
                this.bundleDocumentProviderMap.put(bundle, xmlDocumentProvider);
            }
            return xmlDocumentProvider;
        }
        return null;
    }

    private void releaseXmlDocumentProvider(Bundle bundle) {
        XmlDocumentProvider<T> xmlDocumentProvider;
        if (bundle != null && (xmlDocumentProvider = this.bundleDocumentProviderMap.get(bundle)) != null) {
            try {
                this.logger.debug("Release the XmlDocumentProvider for the module '{}'.", (Object)bundle.getSymbolicName());
                xmlDocumentProvider.release();
            }
            catch (Exception ex) {
                this.logger.error("Could not release the XmlDocumentProvider for the module '" + bundle.getSymbolicName() + "'!", (Throwable)ex);
            }
            this.bundleDocumentProviderMap.remove(bundle);
        }
    }

    private void addingObject(Bundle bundle, T object) {
        XmlDocumentProvider<T> xmlDocumentProvider = this.acquireXmlDocumentProvider(bundle);
        if (xmlDocumentProvider != null) {
            xmlDocumentProvider.addingObject(object);
        }
    }

    private void addingFinished(Bundle bundle) {
        XmlDocumentProvider<T> xmlDocumentProvider = this.bundleDocumentProviderMap.get(bundle);
        if (xmlDocumentProvider != null) {
            try {
                xmlDocumentProvider.addingFinished();
            }
            catch (Exception ex) {
                this.logger.error("Could not send adding finished event for the module '" + bundle.getSymbolicName() + "'!", (Throwable)ex);
            }
        }
    }

    public final synchronized Bundle addingBundle(Bundle bundle, BundleEvent event) {
        Enumeration xmlDocumentPaths = bundle.getEntryPaths(this.xmlDirectory);
        if (xmlDocumentPaths != null) {
            int numberOfParsedXmlDocuments = 0;
            while (xmlDocumentPaths.hasMoreElements()) {
                String moduleName = bundle.getSymbolicName();
                String xmlDocumentPath = (String)xmlDocumentPaths.nextElement();
                URL xmlDocumentURL = bundle.getEntry(xmlDocumentPath);
                String xmlDocumentFile = xmlDocumentURL.getFile();
                try {
                    this.logger.debug("Reading the XML document '{}' in module '{}'...", (Object)xmlDocumentFile, (Object)moduleName);
                    T object = this.xmlDocumentTypeReader.readFromXML(xmlDocumentURL);
                    this.addingObject(bundle, object);
                    ++numberOfParsedXmlDocuments;
                }
                catch (Exception exception) {
                    this.logger.debug("The XML document '{}' in module '{}' is ignored because it contains unknown content.", (Object)xmlDocumentFile, (Object)moduleName);
                }
            }
            if (numberOfParsedXmlDocuments > 0) {
                this.addingFinished(bundle);
                return bundle;
            }
        }
        return null;
    }

    public final synchronized void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        this.logger.debug("Removing the XML related objects from module '{}'...", (Object)bundle.getSymbolicName());
        this.releaseXmlDocumentProvider(bundle);
    }
}

