/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml.util;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.HashMap;
import java.util.Map;

public class ConverterValueMap {
    private HierarchicalStreamReader reader;
    private Map<String, String> valueMap;

    public ConverterValueMap(HierarchicalStreamReader reader) {
        this(reader, -1);
    }

    public ConverterValueMap(HierarchicalStreamReader reader, int numberOfValues) throws ConversionException {
        if (numberOfValues < -1) {
            numberOfValues = -1;
        }
        this.reader = reader;
        this.valueMap = ConverterValueMap.readValueMap(this.reader, numberOfValues);
    }

    public Map<String, String> getValueMap() {
        return this.valueMap;
    }

    public static Map<String, String> readValueMap(HierarchicalStreamReader reader) {
        return ConverterValueMap.readValueMap(reader, -1);
    }

    public static Map<String, String> readValueMap(HierarchicalStreamReader reader, int numberOfValues) throws ConversionException {
        HashMap<String, String> valueMap = new HashMap<String, String>(numberOfValues >= 0 ? numberOfValues : 10);
        int counter = 0;
        while (reader.hasMoreChildren() && (counter < numberOfValues || numberOfValues == -1)) {
            reader.moveDown();
            valueMap.put(reader.getNodeName(), reader.getValue());
            reader.moveUp();
            ++counter;
        }
        if (counter < numberOfValues && numberOfValues > 0) {
            throw new ConversionException("Not all children could be read-in!");
        }
        return valueMap;
    }

    public Object getObject(String nodeName) {
        return this.valueMap.get(nodeName);
    }

    public Object getObject(String nodeName, Object defaultValue) {
        String value = this.valueMap.get(nodeName);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getString(String nodeName) {
        return this.getString(nodeName, null);
    }

    public String getString(String nodeName, String defaultValue) {
        String value = this.valueMap.get(nodeName);
        if (value != null) {
            return value.replaceAll("\\n\\s*", " ").trim();
        }
        return defaultValue;
    }

    public Boolean getBoolean(String nodeName) {
        return this.getBoolean(nodeName, null);
    }

    public Boolean getBoolean(String nodeName, Boolean defaultValue) {
        String value = this.valueMap.get(nodeName);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public Integer getInteger(String nodeName) throws ConversionException {
        return this.getInteger(nodeName, null);
    }

    public Integer getInteger(String nodeName, Integer defaultValue) throws ConversionException {
        String value = this.valueMap.get(nodeName);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new ConversionException("The value '" + value + "' cannot be converted to a numeric value!", (Throwable)nfe);
            }
        }
        return defaultValue;
    }
}

